/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.UnorderedRange;
import adams.core.io.PDFBox;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.data.image.BufferedImageContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PDFRenderPages
extends AbstractTransformer {
    private static final long serialVersionUID = -5712406930007899590L;
    protected UnorderedRange m_Pages;
    protected int m_DPI;
    protected List<BufferedImageContainer> m_Images;

    public String globalInfo() {
        return "Actor for rendering pages of a PDF file as images.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("pages", "pages", (Object)new UnorderedRange("first-last"));
        this.m_OptionManager.add("dpi", "DPI", (Object)72, (Number)1, null);
    }

    protected void initialize() {
        super.initialize();
        this.m_Images = new ArrayList<BufferedImageContainer>();
    }

    public void setPages(UnorderedRange value) {
        this.m_Pages = value;
        this.reset();
    }

    public UnorderedRange getPages() {
        return this.m_Pages;
    }

    public String pagesTipText() {
        return "The range of pages to render.";
    }

    public void setDPI(int value) {
        if (this.getOptionManager().isValid("DPI", (Number)value)) {
            this.m_DPI = value;
            this.reset();
        }
    }

    public int getDPI() {
        return this.m_DPI;
    }

    public String DPITipText() {
        return "The DPI to use (dots per inch).";
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{BufferedImageContainer.class};
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"pages", (Object)this.m_Pages, (String)"pages: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"DPI", (Object)this.m_DPI, (String)", DPI: ");
        return result;
    }

    protected String doExecute() {
        Object result = null;
        File file = this.m_InputToken.getPayload() instanceof File ? (File)this.m_InputToken.getPayload() : new PlaceholderFile((String)this.m_InputToken.getPayload());
        PDDocument doc = PDFBox.load(file);
        if (doc != null) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Rendering pages from '" + file + "'");
            }
            this.m_Pages.setMax(doc.getNumberOfPages());
            PDFRenderer renderer = new PDFRenderer(doc);
            MessageCollection errors = new MessageCollection();
            for (int page : this.m_Pages.getIntIndices()) {
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Rendering page #" + (page + 1));
                }
                try {
                    BufferedImage img = renderer.renderImageWithDPI(page, (float)this.m_DPI);
                    BufferedImageContainer cont = new BufferedImageContainer();
                    cont.setImage((Object)img);
                    cont.getReport().setStringValue("File", file.getAbsolutePath());
                    cont.getReport().setNumericValue("Page", (double)(page + 1));
                    this.m_Images.add(cont);
                }
                catch (Exception e) {
                    errors.add(this.handleException("Failed to render page #" + (page + 1) + " from " + file, e));
                }
            }
            if (!errors.isEmpty()) {
                result = errors.toString();
            }
        } else {
            result = "Failed to load PDF document: " + file;
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_Images.size() > 0;
    }

    public Token output() {
        Token result = new Token((Object)this.m_Images.get(0));
        this.m_Images.remove(0);
        this.m_InputToken = null;
        return result;
    }
}

