/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.pdfstamp.AbstractStamper;
import adams.flow.transformer.pdfstamp.PassThrough;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class PDFStamp
extends AbstractTransformer {
    private static final long serialVersionUID = 5783362940767103716L;
    protected AbstractStamper m_Stamper;
    protected PlaceholderFile m_Output;

    public String globalInfo() {
        return "Actor for stamping pages in a PDF with a custom overlay.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("stamper", "stamper", (Object)new PassThrough());
        this.m_OptionManager.add("output", "output", (Object)new PlaceholderFile("."));
    }

    public void setStamper(AbstractStamper value) {
        this.m_Stamper = value;
        this.reset();
    }

    public AbstractStamper getStamper() {
        return this.m_Stamper;
    }

    public String stamperTipText() {
        return "The stamping algorithm to apply to the PDF.";
    }

    public void setOutput(PlaceholderFile value) {
        this.m_Output = value;
        this.reset();
    }

    public PlaceholderFile getOutput() {
        return this.m_Output;
    }

    public String outputTipText() {
        return "The PDF file to save the combined PDF to.";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"stamper", (Object)((Object)this.m_Stamper), (String)"stamper: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"output", (Object)this.m_Output, (String)", output: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected String doExecute() {
        String result;
        block23: {
            result = null;
            PlaceholderFile file = this.m_InputToken.getPayload() instanceof String ? new PlaceholderFile((String)this.m_InputToken.getPayload()) : new PlaceholderFile((File)this.m_InputToken.getPayload());
            PdfReader reader = null;
            PdfStamper stamper = null;
            FileOutputStream fos = null;
            reader = new PdfReader(file.getAbsolutePath());
            fos = new FileOutputStream(this.m_Output.getAbsolutePath());
            stamper = new PdfStamper(reader, (OutputStream)fos);
            this.m_Stamper.stamp(stamper);
            try {
                if (stamper != null) {
                    stamper.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            FileUtils.closeQuietly((OutputStream)fos);
            break block23;
            catch (Exception e) {
                try {
                    result = this.handleException("Failed to stamp PDF file: " + file, e);
                }
                catch (Throwable throwable) {
                    try {
                        if (stamper != null) {
                            stamper.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    FileUtils.closeQuietly(fos);
                    throw throwable;
                }
                try {
                    if (stamper != null) {
                        stamper.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                FileUtils.closeQuietly((OutputStream)fos);
            }
        }
        if (result == null) {
            this.m_OutputToken = new Token((Object)this.m_Output.getAbsolutePath());
        }
        return result;
    }
}

