/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.pdfproclet;

import adams.core.base.BaseFloat;
import adams.core.base.BaseString;
import adams.core.io.PdfFont;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetSupporter;
import adams.flow.transformer.pdfproclet.AbstractPdfProcletWithPageBreaks;
import adams.flow.transformer.pdfproclet.PDFGenerator;
import adams.flow.transformer.pdfproclet.PdfProcletWithOptionalAbsolutePosition;
import adams.flow.transformer.pdfproclet.PdfProcletWithVariableFileExtension;
import com.itextpdf.text.BaseColor;
import java.awt.Color;
import java.io.File;

public abstract class AbstractSpreadSheetPdfProclet
extends AbstractPdfProcletWithPageBreaks
implements PdfProcletWithVariableFileExtension,
PdfProcletWithOptionalAbsolutePosition {
    private static final long serialVersionUID = -5894153152920062499L;
    protected PdfFont m_FontTableHeader;
    protected Color m_ColorTableHeader;
    protected Color m_BackgroundTableHeader;
    protected PdfFont m_FontGeneralContent;
    protected Color m_ColorGeneralContent;
    protected PdfFont m_FontNumericContent;
    protected Color m_ColorNumericContent;
    protected BaseString[] m_Extensions;
    protected int m_NumDecimals;
    protected SpreadSheetReader m_Reader;
    protected float m_WidthPercentage;
    protected HorizontalAlignment m_HorizontalAlignment;
    protected boolean m_UseAbsolutePosition;
    protected float m_X;
    protected float m_Y;
    protected BaseFloat[] m_RelativeColumnWidths;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("font-table-header", "fontTableHeader", (Object)new PdfFont("Helvetica", "Bold", 12.0f));
        this.m_OptionManager.add("color-table-header", "colorTableHeader", (Object)Color.BLACK);
        this.m_OptionManager.add("background-table-header", "backgroundTableHeader", (Object)Color.LIGHT_GRAY);
        this.m_OptionManager.add("font-general-content", "fontGeneralContent", (Object)new PdfFont("Helvetica", "Normal", 12.0f));
        this.m_OptionManager.add("color-general-content", "colorGeneralContent", (Object)Color.BLACK);
        this.m_OptionManager.add("font-numeric-content", "fontNumericContent", (Object)new PdfFont("Helvetica", "Normal", 12.0f));
        this.m_OptionManager.add("color-numeric-content", "colorNumericContent", (Object)Color.BLACK);
        this.m_OptionManager.add("num-decimals", "numDecimals", (Object)1, (Number)0, null);
        this.m_OptionManager.add("extension", "extensions", (Object)new BaseString[]{new BaseString("csv")});
        this.m_OptionManager.add("reader", "reader", (Object)new CsvSpreadSheetReader());
        this.m_OptionManager.add("width-percentage", "widthPercentage", (Object)Float.valueOf(100.0f), (Number)Float.valueOf(0.0f), (Number)Float.valueOf(100.0f));
        this.m_OptionManager.add("horizontal-alignment", "horizontalAlignment", (Object)HorizontalAlignment.CENTER);
        this.m_OptionManager.add("use-absolute-position", "useAbsolutePosition", (Object)false);
        this.m_OptionManager.add("x", "X", (Object)Float.valueOf(0.0f), (Number)Float.valueOf(0.0f), null);
        this.m_OptionManager.add("y", "Y", (Object)Float.valueOf(0.0f), (Number)Float.valueOf(0.0f), null);
        this.m_OptionManager.add("rel-col-width", "relativeColumnWidths", (Object)new BaseFloat[0]);
    }

    public void setFontTableHeader(PdfFont value) {
        this.m_FontTableHeader = value;
        this.reset();
    }

    public PdfFont getFontTableHeader() {
        return this.m_FontTableHeader;
    }

    public String fontTableHeaderTipText() {
        return "The font to use for the table header.";
    }

    public void setColorTableHeader(Color value) {
        this.m_ColorTableHeader = value;
        this.reset();
    }

    public Color getColorTableHeader() {
        return this.m_ColorTableHeader;
    }

    public String colorTableHeaderTipText() {
        return "The color to use for the table header.";
    }

    public void setBackgroundTableHeader(Color value) {
        this.m_BackgroundTableHeader = value;
        this.reset();
    }

    public Color getBackgroundTableHeader() {
        return this.m_BackgroundTableHeader;
    }

    public String backgroundTableHeaderTipText() {
        return "The background color to use for the table header.";
    }

    public void setFontGeneralContent(PdfFont value) {
        this.m_FontGeneralContent = value;
        this.reset();
    }

    public PdfFont getFontGeneralContent() {
        return this.m_FontGeneralContent;
    }

    public String fontGeneralContentTipText() {
        return "The font to use for non-numeric content in the table.";
    }

    public void setColorGeneralContent(Color value) {
        this.m_ColorGeneralContent = value;
        this.reset();
    }

    public Color getColorGeneralContent() {
        return this.m_ColorGeneralContent;
    }

    public String colorGeneralContentTipText() {
        return "The color to use for general content.";
    }

    public void setFontNumericContent(PdfFont value) {
        this.m_FontNumericContent = value;
        this.reset();
    }

    public PdfFont getFontNumericContent() {
        return this.m_FontNumericContent;
    }

    public String fontNumericContentTipText() {
        return "The font to use for numeric content in the table.";
    }

    public void setColorNumericContent(Color value) {
        this.m_ColorNumericContent = value;
        this.reset();
    }

    public Color getColorNumericContent() {
        return this.m_ColorNumericContent;
    }

    public String colorNumericContentTipText() {
        return "The color to use for numeric content.";
    }

    @Override
    public BaseString[] getExtensions() {
        return this.m_Extensions;
    }

    @Override
    public void setExtensions(BaseString[] value) {
        this.m_Extensions = value;
        this.reset();
    }

    @Override
    public String extensionsTipText() {
        return "The file extension(s) that the processor will be used for.";
    }

    public void setNumDecimals(int value) {
        if (value >= 0) {
            this.m_NumDecimals = value;
            this.reset();
        } else {
            System.err.println("Number of decimals cannot be negative!");
        }
    }

    public int getNumDecimals() {
        return this.m_NumDecimals;
    }

    public String numDecimalsTipText() {
        return "The number of decimals for numeric values in the table.";
    }

    public void setReader(SpreadSheetReader value) {
        this.m_Reader = value;
        this.reset();
    }

    public SpreadSheetReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The reader to use for loading the spreadsheet files.";
    }

    public void setWidthPercentage(float value) {
        if (this.getOptionManager().isValid("widthPercentage", (Number)Float.valueOf(value))) {
            this.m_WidthPercentage = value;
            this.reset();
        }
    }

    public float getWidthPercentage() {
        return this.m_WidthPercentage;
    }

    public String widthPercentageTipText() {
        return "The percentage of the page width to occupy.";
    }

    public void setHorizontalAlignment(HorizontalAlignment value) {
        this.m_HorizontalAlignment = value;
        this.reset();
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.m_HorizontalAlignment;
    }

    public String horizontalAlignmentTipText() {
        return "How to align the table on the page horizontally when not 100% wide.";
    }

    @Override
    public void setUseAbsolutePosition(boolean value) {
        this.m_UseAbsolutePosition = value;
        this.reset();
    }

    @Override
    public boolean getUseAbsolutePosition() {
        return this.m_UseAbsolutePosition;
    }

    @Override
    public String useAbsolutePositionTipText() {
        return "If enabled, the absolute position is used (from bottom-left corner).";
    }

    @Override
    public void setX(float value) {
        if (this.getOptionManager().isValid("X", (Number)Float.valueOf(value))) {
            this.m_X = value;
            this.reset();
        }
    }

    @Override
    public float getX() {
        return this.m_X;
    }

    @Override
    public String XTipText() {
        return "The absolute X position.";
    }

    @Override
    public void setY(float value) {
        if (this.getOptionManager().isValid("Y", (Number)Float.valueOf(value))) {
            this.m_Y = value;
            this.reset();
        }
    }

    @Override
    public float getY() {
        return this.m_Y;
    }

    @Override
    public String YTipText() {
        return "The absolute Y position.";
    }

    public void setRelativeColumnWidths(BaseFloat[] value) {
        this.m_RelativeColumnWidths = value;
        this.reset();
    }

    public BaseFloat[] getRelativeColumnWidths() {
        return this.m_RelativeColumnWidths;
    }

    public String relativeColumnWidthsTipText() {
        return "The relative column widths (0-1), ignored if not provided, uses 1 by default.";
    }

    protected BaseColor toBaseColor(Color color) {
        return new BaseColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    protected float[] relativeColumnsWidths(SpreadSheet sheet) {
        float[] result = new float[sheet.getColumnCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = i < this.m_RelativeColumnWidths.length ? this.m_RelativeColumnWidths[i].floatValue() : 1.0f;
        }
        return result;
    }

    @Override
    protected boolean doProcess(PDFGenerator generator, File file) throws Exception {
        boolean result = this.addFilename(generator, file);
        if (!result) {
            return false;
        }
        SpreadSheet sheet = this.m_Reader.read(file.getAbsolutePath());
        return sheet != null && this.doProcess(generator, sheet);
    }

    @Override
    public boolean canProcess(PDFGenerator generator, Object obj) {
        return obj instanceof SpreadSheet || obj instanceof SpreadSheetSupporter;
    }

    protected abstract boolean doProcess(PDFGenerator var1, SpreadSheet var2) throws Exception;

    @Override
    protected boolean doProcess(PDFGenerator generator, Object obj) throws Exception {
        if (obj instanceof SpreadSheet) {
            return this.doProcess(generator, (SpreadSheet)obj);
        }
        if (obj instanceof SpreadSheetSupporter) {
            return this.doProcess(generator, ((SpreadSheetSupporter)obj).toSpreadSheet());
        }
        return false;
    }

    public static enum HorizontalAlignment {
        LEFT(0),
        CENTER(1),
        RIGHT(2);

        private int m_Alignment;

        private HorizontalAlignment(int alignment) {
            this.m_Alignment = alignment;
        }

        public int getAlignment() {
            return this.m_Alignment;
        }
    }
}

