/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.pdfproclet;

import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.flow.transformer.pdfproclet.AbstractSpreadSheetPdfProclet;
import adams.flow.transformer.pdfproclet.PDFGenerator;
import adams.gui.visualization.core.BiColorGenerator;
import adams.gui.visualization.core.ColorGradientGenerator;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Element;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

public class ConfusionMatrix
extends AbstractSpreadSheetPdfProclet {
    private static final long serialVersionUID = -5894153152920062499L;
    protected Color m_BackgroundDiagonal;
    protected boolean m_ValueBasedBackground;
    protected ColorGradientGenerator m_BackgroundColorGenerator;
    protected transient Map<Integer, Color> m_Colors;

    public String globalInfo() {
        return "Adds CSV files (or any spreadsheet files that is supported) as table.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("background-diagonal", "backgroundDiagonal", (Object)Color.LIGHT_GRAY);
        this.m_OptionManager.add("value-based-background", "valueBasedBackground", (Object)false);
        this.m_OptionManager.add("background-color-generator", "backgroundColorGenerator", (Object)this.getDefaultBackgroundColorGenerator());
    }

    protected void reset() {
        super.reset();
        this.m_Colors = null;
    }

    public void setBackgroundDiagonal(Color value) {
        this.m_BackgroundDiagonal = value;
        this.reset();
    }

    public Color getBackgroundDiagonal() {
        return this.m_BackgroundDiagonal;
    }

    public String backgroundDiagonalTipText() {
        return "The background color to use for the diagonal.";
    }

    public void setValueBasedBackground(boolean value) {
        this.m_ValueBasedBackground = value;
        this.reset();
    }

    public boolean getValueBasedBackground() {
        return this.m_ValueBasedBackground;
    }

    public String valueBasedBackgroundTipText() {
        return "If enabled, the background of the cells gets colored in based on their value.";
    }

    protected ColorGradientGenerator getDefaultBackgroundColorGenerator() {
        BiColorGenerator result = new BiColorGenerator();
        result.setFirstColor(Color.WHITE);
        result.setSecondColor(Color.RED);
        return result;
    }

    public void setBackgroundColorGenerator(ColorGradientGenerator value) {
        this.m_BackgroundColorGenerator = value;
        this.reset();
    }

    public ColorGradientGenerator getBackgroundColorGenerator() {
        return this.m_BackgroundColorGenerator;
    }

    public String backgroundColorGeneratorTipText() {
        return "The color generator to use for obtaining the colors for coloring in the backgrounds.";
    }

    protected synchronized void initColors() {
        if (this.m_Colors != null) {
            return;
        }
        this.m_Colors = new HashMap<Integer, Color>();
        Color[] colors = this.m_BackgroundColorGenerator.generate();
        for (int i = 0; i < colors.length; ++i) {
            this.m_Colors.put(i, colors[i]);
        }
    }

    public Color getBackgroundColor(SpreadSheet sheet, int row, int column) {
        Cell spCell;
        double max;
        double[] minMax;
        double min;
        this.initColors();
        Color result = null;
        if (column == 0) {
            return this.getBackgroundTableHeader();
        }
        if (column - 1 == row) {
            return this.getBackgroundDiagonal();
        }
        if (this.m_ValueBasedBackground && (min = (minMax = SpreadSheetUtils.getMinMax((SpreadSheet)sheet, null, null))[0]) < (max = minMax[1]) && (spCell = sheet.getCell(row, column)) != null && spCell.isNumeric()) {
            double value = spCell.toDouble();
            int index = (int)((value - min) / (max - min) * (double)(this.m_Colors.size() - 1));
            result = this.m_Colors.get(index);
        }
        return result;
    }

    @Override
    protected BaseColor toBaseColor(Color color) {
        return new BaseColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    @Override
    protected boolean doProcess(PDFGenerator generator, SpreadSheet sheet) throws Exception {
        PdfPCell pdfCell;
        Cell cell;
        boolean result;
        int y;
        this.initColors();
        Object pattern = "#0";
        for (y = 0; y < this.m_NumDecimals; ++y) {
            if (y == 0) {
                pattern = (String)pattern + ".";
            }
            pattern = (String)pattern + "0";
        }
        DecimalFormat format = new DecimalFormat((String)pattern);
        boolean bl = result = sheet != null;
        if (!result) {
            return false;
        }
        PdfPTable table = this.m_RelativeColumnWidths.length == 0 ? new PdfPTable(sheet.getColumnCount()) : new PdfPTable(this.relativeColumnsWidths(sheet));
        table.setWidthPercentage(this.m_WidthPercentage);
        table.setHorizontalAlignment(this.m_HorizontalAlignment.getAlignment());
        table.setHeaderRows(1);
        HeaderRow row = sheet.getHeaderRow();
        for (String key : sheet.getHeaderRow().cellKeys()) {
            cell = row.getCell(key);
            Paragraph para = new Paragraph(cell.toString(), this.m_FontTableHeader.toFont(this.m_ColorTableHeader));
            pdfCell = new PdfPCell((Phrase)para);
            pdfCell.setBackgroundColor(this.toBaseColor(this.m_BackgroundTableHeader));
            pdfCell.setHorizontalAlignment(0);
            table.addCell(pdfCell);
        }
        for (y = 0; y < sheet.getRowCount(); ++y) {
            row = sheet.getRow(y);
            for (int x = 0; x < sheet.getColumnCount(); ++x) {
                cell = row.getCell(x);
                if (cell == null || cell.isMissing()) {
                    pdfCell = new PdfPCell((Phrase)new Paragraph(""));
                } else if (cell.getContentType() == Cell.ContentType.LONG) {
                    pdfCell = new PdfPCell((Phrase)new Paragraph(cell.toString(), this.m_FontNumericContent.toFont(this.m_ColorNumericContent)));
                    pdfCell.setHorizontalAlignment(2);
                } else if (cell.isNumeric()) {
                    pdfCell = new PdfPCell((Phrase)new Paragraph(format.format(cell.toDouble()), this.m_FontNumericContent.toFont(this.m_ColorNumericContent)));
                    pdfCell.setHorizontalAlignment(2);
                } else {
                    pdfCell = new PdfPCell((Phrase)new Paragraph(cell.toString(), this.m_FontGeneralContent.toFont(this.m_ColorGeneralContent)));
                    pdfCell.setHorizontalAlignment(0);
                }
                Color bgColor = this.getBackgroundColor(sheet, y, x);
                if (bgColor != null) {
                    pdfCell.setBackgroundColor(this.toBaseColor(bgColor));
                }
                table.addCell(pdfCell);
            }
        }
        if (this.m_UseAbsolutePosition) {
            ColumnText ct = this.addColumnTextAt(generator, this.m_X, this.m_Y);
            ct.addElement((Element)new Paragraph("\n"));
            ct.addElement((Element)table);
            ct.go();
            generator.getState().contentAdded();
        } else {
            result = this.addElement(generator, (Element)new Paragraph("\n"));
            if (result) {
                result = this.addElement(generator, (Element)table);
            }
        }
        return result;
    }
}

