/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.pdfproclet;

import adams.core.Utils;
import adams.core.base.BaseString;
import adams.core.base.BaseText;
import adams.core.io.PdfFont;
import adams.flow.transformer.pdfproclet.AbstractPdfProclet;
import adams.flow.transformer.pdfproclet.PDFGenerator;
import adams.flow.transformer.pdfproclet.PdfProcletWithOptionalAbsolutePosition;
import adams.flow.transformer.pdfproclet.PdfProcletWithPageBreaks;
import adams.flow.transformer.pdfproclet.PdfProcletWithVariableFileExtension;
import com.itextpdf.text.Element;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.ColumnText;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FixedText
extends AbstractPdfProclet
implements PdfProcletWithPageBreaks,
PdfProcletWithVariableFileExtension,
PdfProcletWithOptionalAbsolutePosition {
    private static final long serialVersionUID = 3962046484864891107L;
    protected BaseText m_TextContent;
    protected boolean m_PageBreakBefore;
    protected boolean m_PageBreakAfter;
    protected int m_NumFilesPerPage;
    protected PdfFont m_FontContent;
    protected Color m_ColorContent;
    protected BaseString[] m_Extensions;
    protected boolean m_UseAbsolutePosition;
    protected float m_X;
    protected float m_Y;

    public String globalInfo() {
        return "Adds the fixed text line by line, variables get expanded automatically.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("text-content", "textContent", (Object)new BaseText());
        this.m_OptionManager.add("page-break-before", "pageBreakBefore", (Object)false);
        this.m_OptionManager.add("page-break-after", "pageBreakAfter", (Object)false);
        this.m_OptionManager.add("num-files", "numFilesPerPage", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("font-content", "fontContent", (Object)new PdfFont("Helvetica", "Normal", 12.0f));
        this.m_OptionManager.add("color-content", "colorContent", (Object)Color.BLACK);
        this.m_OptionManager.add("extension", "extensions", (Object)new BaseString[]{new BaseString("txt")});
        this.m_OptionManager.add("use-absolute-position", "useAbsolutePosition", (Object)false);
        this.m_OptionManager.add("x", "X", (Object)Float.valueOf(0.0f), (Number)Float.valueOf(0.0f), null);
        this.m_OptionManager.add("y", "Y", (Object)Float.valueOf(0.0f), (Number)Float.valueOf(0.0f), null);
    }

    public void setTextContent(BaseText value) {
        this.m_TextContent = value;
        this.reset();
    }

    public BaseText getTextContent() {
        return this.m_TextContent;
    }

    public String textContentTipText() {
        return "The content to insert; variables get expanded automatically.";
    }

    @Override
    public void setPageBreakBefore(boolean value) {
        this.m_PageBreakBefore = value;
        this.reset();
    }

    @Override
    public boolean getPageBreakBefore() {
        return this.m_PageBreakBefore;
    }

    @Override
    public String pageBreakBeforeTipText() {
        return "If true, then a page-break is added before the content of the file is inserted.";
    }

    @Override
    public void setPageBreakAfter(boolean value) {
        this.m_PageBreakAfter = value;
        this.reset();
    }

    @Override
    public boolean getPageBreakAfter() {
        return this.m_PageBreakAfter;
    }

    @Override
    public String pageBreakAfterTipText() {
        return "If true, then a page-break is added after the content of the file is inserted.";
    }

    @Override
    public void setNumFilesPerPage(int value) {
        if (this.getOptionManager().isValid("numFilesPerPage", (Number)value)) {
            this.m_NumFilesPerPage = value;
            this.reset();
        }
    }

    @Override
    public int getNumFilesPerPage() {
        return this.m_NumFilesPerPage;
    }

    @Override
    public String numFilesPerPageTipText() {
        return "The number of files to put on a page before adding an automatic page break; use -1 for unlimited.";
    }

    public void setFontContent(PdfFont value) {
        this.m_FontContent = value;
        this.reset();
    }

    public PdfFont getFontContent() {
        return this.m_FontContent;
    }

    public String fontContentTipText() {
        return "The font to use for the file content.";
    }

    public void setColorContent(Color value) {
        this.m_ColorContent = value;
        this.reset();
    }

    public Color getColorContent() {
        return this.m_ColorContent;
    }

    public String colorContentTipText() {
        return "The color to use for the content.";
    }

    @Override
    public BaseString[] getExtensions() {
        return this.m_Extensions;
    }

    @Override
    public void setExtensions(BaseString[] value) {
        this.m_Extensions = value;
        this.reset();
    }

    @Override
    public String extensionsTipText() {
        return "The file extension(s) that the processor will be used for.";
    }

    @Override
    public void setUseAbsolutePosition(boolean value) {
        this.m_UseAbsolutePosition = value;
        this.reset();
    }

    @Override
    public boolean getUseAbsolutePosition() {
        return this.m_UseAbsolutePosition;
    }

    @Override
    public String useAbsolutePositionTipText() {
        return "If enabled, the absolute position is used (from bottom-left corner).";
    }

    @Override
    public void setX(float value) {
        if (this.getOptionManager().isValid("X", (Number)Float.valueOf(value))) {
            this.m_X = value;
            this.reset();
        }
    }

    @Override
    public float getX() {
        return this.m_X;
    }

    @Override
    public String XTipText() {
        return "The absolute X position.";
    }

    @Override
    public void setY(float value) {
        if (this.getOptionManager().isValid("Y", (Number)Float.valueOf(value))) {
            this.m_Y = value;
            this.reset();
        }
    }

    @Override
    public float getY() {
        return this.m_Y;
    }

    @Override
    public String YTipText() {
        return "The absolute Y position.";
    }

    protected boolean doProcess(PDFGenerator generator, List<String> paragraphs) throws Exception {
        boolean result = true;
        if (this.m_UseAbsolutePosition) {
            ColumnText ct = this.addColumnTextAt(generator, this.m_X, this.m_Y);
            ct.addElement((Element)new Paragraph(Utils.flatten(paragraphs, (String)"\n"), this.m_FontContent.toFont(this.m_ColorContent)));
            ct.go();
            generator.getState().contentAdded();
        } else {
            result = this.addElement(generator, (Element)new Paragraph(Utils.flatten(paragraphs, (String)"\n"), this.m_FontContent.toFont(this.m_ColorContent)));
        }
        return result;
    }

    protected boolean insertContent(PDFGenerator generator) throws Exception {
        ArrayList<String> paragraphs = new ArrayList<String>(Arrays.asList(this.m_OptionManager.getVariables().expand(this.m_TextContent.getValue()).split("\n")));
        return this.doProcess(generator, paragraphs);
    }

    @Override
    protected boolean doProcess(PDFGenerator generator, File file) throws Exception {
        return this.insertContent(generator);
    }

    @Override
    public boolean canProcess(PDFGenerator generator, Object obj) {
        return true;
    }

    @Override
    protected boolean doProcess(PDFGenerator generator, Object obj) throws Exception {
        return this.insertContent(generator);
    }
}

