/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.pdfproclet;

import adams.core.base.BaseString;
import adams.core.base.BaseText;
import adams.core.io.PdfFont;
import adams.flow.transformer.pdfproclet.AbstractPdfProclet;
import adams.flow.transformer.pdfproclet.PDFGenerator;
import adams.flow.transformer.pdfproclet.PdfProcletWithPageBreaks;
import adams.flow.transformer.pdfproclet.PdfProcletWithVariableFileExtension;
import com.itextpdf.text.Element;
import com.itextpdf.text.Paragraph;
import java.awt.Color;
import java.io.File;

public class Headline
extends AbstractPdfProclet
implements PdfProcletWithPageBreaks,
PdfProcletWithVariableFileExtension {
    private static final long serialVersionUID = 3962046484864891107L;
    protected boolean m_PageBreakBefore;
    protected boolean m_PageBreakAfter;
    protected int m_NumFilesPerPage;
    protected BaseText m_Headline;
    protected PdfFont m_FontHeadline;
    protected Color m_ColorHeadline;
    protected BaseString[] m_Extensions;
    protected boolean m_FirstPageOnly;

    public String globalInfo() {
        return "Adds a simple headline, but no file content.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("page-break-before", "pageBreakBefore", (Object)false);
        this.m_OptionManager.add("page-break-after", "pageBreakAfter", (Object)false);
        this.m_OptionManager.add("num-files", "numFilesPerPage", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("headline", "headline", (Object)new BaseText("Fill in headline"));
        this.m_OptionManager.add("font-headline", "fontHeadline", (Object)new PdfFont("Helvetica", "Bold", 14.0f));
        this.m_OptionManager.add("color-headline", "colorHeadline", (Object)Color.BLACK);
        this.m_OptionManager.add("extension", "extensions", (Object)new BaseString[]{new BaseString("*")});
        this.m_OptionManager.add("first-page-only", "firstPageOnly", (Object)false);
    }

    @Override
    public void setPageBreakBefore(boolean value) {
        this.m_PageBreakBefore = value;
        this.reset();
    }

    @Override
    public boolean getPageBreakBefore() {
        return this.m_PageBreakBefore;
    }

    @Override
    public String pageBreakBeforeTipText() {
        return "If true, then a page-break is added before the content of the file is inserted.";
    }

    @Override
    public void setPageBreakAfter(boolean value) {
        this.m_PageBreakAfter = value;
        this.reset();
    }

    @Override
    public boolean getPageBreakAfter() {
        return this.m_PageBreakAfter;
    }

    @Override
    public String pageBreakAfterTipText() {
        return "If true, then a page-break is added after the content of the file is inserted.";
    }

    @Override
    public void setNumFilesPerPage(int value) {
        if (this.getOptionManager().isValid("numFilesPerPage", (Number)value)) {
            this.m_NumFilesPerPage = value;
            this.reset();
        }
    }

    @Override
    public int getNumFilesPerPage() {
        return this.m_NumFilesPerPage;
    }

    @Override
    public String numFilesPerPageTipText() {
        return "The number of files to put on a page before adding an automatic page break; use -1 for unlimited.";
    }

    public void setHeadline(BaseText value) {
        this.m_Headline = value;
        this.reset();
    }

    public BaseText getHeadline() {
        return this.m_Headline;
    }

    public String headlineTipText() {
        return "The headline to add, can be multi-line; variables get expanded automatically.";
    }

    public void setFontHeadline(PdfFont value) {
        this.m_FontHeadline = value;
        this.reset();
    }

    public PdfFont getFontHeadline() {
        return this.m_FontHeadline;
    }

    public String fontHeadlineTipText() {
        return "The font to use for the headline.";
    }

    public void setColorHeadline(Color value) {
        this.m_ColorHeadline = value;
        this.reset();
    }

    public Color getColorHeadline() {
        return this.m_ColorHeadline;
    }

    public String colorHeadlineTipText() {
        return "The color to use for the headline.";
    }

    @Override
    public BaseString[] getExtensions() {
        return this.m_Extensions;
    }

    @Override
    public void setExtensions(BaseString[] value) {
        this.m_Extensions = value;
        this.reset();
    }

    @Override
    public String extensionsTipText() {
        return "The file extension(s) that the processor will be used for.";
    }

    public void setFirstPageOnly(boolean value) {
        this.m_FirstPageOnly = value;
        this.reset();
    }

    public boolean getFirstPageOnly() {
        return this.m_FirstPageOnly;
    }

    public String firstPageOnlyTipText() {
        return "If set to true, then the headline is only added to the first page.";
    }

    @Override
    public boolean canProcess(PDFGenerator generator, File file) {
        if (this.m_FirstPageOnly) {
            if (generator.getState().numTotalFiles() == 0) {
                return super.canProcess(generator, file);
            }
            return false;
        }
        return super.canProcess(generator, file);
    }

    @Override
    protected boolean preProcess(PDFGenerator generator, File file) throws Exception {
        boolean result = super.preProcess(generator, file);
        if (result && this.m_PageBreakBefore) {
            result = generator.newPage();
        }
        return result;
    }

    @Override
    protected boolean doProcess(PDFGenerator generator, File file) throws Exception {
        return this.addElement(generator, (Element)new Paragraph(this.m_OptionManager.getVariables().expand(this.m_Headline.getValue()), this.m_FontHeadline.toFont(this.m_ColorHeadline)));
    }

    @Override
    protected boolean postProcess(PDFGenerator generator, File file) throws Exception {
        boolean result = super.postProcess(generator, file);
        if (result && (this.m_PageBreakAfter || generator.getState().numCurrentFiles() == this.m_NumFilesPerPage)) {
            result = generator.getDocument().newPage();
            generator.getState().resetCurrentFiles();
        }
        return result;
    }

    @Override
    public boolean canProcess(PDFGenerator generator, Object obj) {
        return true;
    }

    @Override
    protected boolean preProcess(PDFGenerator generator, Object obj) throws Exception {
        boolean result = super.preProcess(generator, obj);
        if (result && this.m_PageBreakBefore) {
            result = generator.newPage();
        }
        return result;
    }

    @Override
    protected boolean doProcess(PDFGenerator generator, Object obj) throws Exception {
        return this.addElement(generator, (Element)new Paragraph(this.m_OptionManager.getVariables().expand(this.m_Headline.getValue()), this.m_FontHeadline.toFont(this.m_ColorHeadline)));
    }

    @Override
    protected boolean postProcess(PDFGenerator generator, Object obj) throws Exception {
        boolean result = super.postProcess(generator, obj);
        if (result && (this.m_PageBreakAfter || generator.getState().numCurrentFiles() == this.m_NumFilesPerPage)) {
            result = generator.getDocument().newPage();
            generator.getState().resetCurrentFiles();
        }
        return result;
    }
}

