/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.pdfproclet;

import adams.core.base.BaseString;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.BufferedImageSupporter;
import adams.flow.transformer.pdfproclet.AbstractPdfProcletWithPageBreaks;
import adams.flow.transformer.pdfproclet.PDFGenerator;
import adams.flow.transformer.pdfproclet.PdfProcletWithOptionalAbsolutePosition;
import com.itextpdf.text.Element;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;

public class Image
extends AbstractPdfProcletWithPageBreaks
implements PdfProcletWithOptionalAbsolutePosition {
    private static final long serialVersionUID = 3962046484864891107L;
    protected int m_Rotation;
    protected double m_Scale;
    protected boolean m_UseAbsolutePosition;
    protected float m_X;
    protected float m_Y;

    public String globalInfo() {
        return "Adds GIF, JPEG and PNG image files.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("rotation", "rotation", (Object)0, (Number)0, (Number)360);
        this.m_OptionManager.add("scale", "scale", (Object)1.0, (Number)0.0, (Number)1.0);
        this.m_OptionManager.add("use-absolute-position", "useAbsolutePosition", (Object)false);
        this.m_OptionManager.add("x", "X", (Object)Float.valueOf(0.0f), (Number)Float.valueOf(0.0f), null);
        this.m_OptionManager.add("y", "Y", (Object)Float.valueOf(0.0f), (Number)Float.valueOf(0.0f), null);
    }

    public void setRotation(int value) {
        if (this.getOptionManager().isValid("rotation", (Number)value)) {
            this.m_Rotation = value;
            this.reset();
        }
    }

    public int getRotation() {
        return this.m_Rotation;
    }

    public String rotationTipText() {
        return "The rotation in degrees.";
    }

    public void setScale(double value) {
        if (this.getOptionManager().isValid("scale", (Number)value)) {
            this.m_Scale = value;
            this.reset();
        }
    }

    public double getScale() {
        return this.m_Scale;
    }

    public String scaleTipText() {
        return "The scaling factor for the image, ie, scaling it to the page dimensions; use 0 to turn scaling off.";
    }

    @Override
    public void setUseAbsolutePosition(boolean value) {
        this.m_UseAbsolutePosition = value;
        this.reset();
    }

    @Override
    public boolean getUseAbsolutePosition() {
        return this.m_UseAbsolutePosition;
    }

    @Override
    public String useAbsolutePositionTipText() {
        return "If enabled, the absolute position is used (from bottom-left corner).";
    }

    @Override
    public void setX(float value) {
        if (this.getOptionManager().isValid("X", (Number)Float.valueOf(value))) {
            this.m_X = value;
            this.reset();
        }
    }

    @Override
    public float getX() {
        return this.m_X;
    }

    @Override
    public String XTipText() {
        return "The absolute X position.";
    }

    @Override
    public void setY(float value) {
        if (this.getOptionManager().isValid("Y", (Number)Float.valueOf(value))) {
            this.m_Y = value;
            this.reset();
        }
    }

    @Override
    public float getY() {
        return this.m_Y;
    }

    @Override
    public String YTipText() {
        return "The absolute Y position.";
    }

    @Override
    public BaseString[] getExtensions() {
        return new BaseString[]{new BaseString("gif"), new BaseString("jpg"), new BaseString("jpeg"), new BaseString("png")};
    }

    protected boolean doProcess(PDFGenerator generator, BufferedImage img) throws Exception {
        com.itextpdf.text.Image image = com.itextpdf.text.Image.getInstance((java.awt.Image)img, (Color)Color.WHITE);
        if (this.m_Rotation != 0) {
            image.setRotationDegrees((float)this.m_Rotation);
            image.rotate();
        }
        if (this.m_Scale > 0.0) {
            float scale = (float)this.m_Scale;
            image.scaleToFit(generator.getDocument().getPageSize().getWidth() * scale, generator.getDocument().getPageSize().getHeight() * scale);
        }
        if (this.m_UseAbsolutePosition) {
            image.setAbsolutePosition(this.m_X, this.m_Y);
        }
        boolean result = this.addElement(generator, (Element)image);
        return result;
    }

    @Override
    protected boolean doProcess(PDFGenerator generator, File file) throws Exception {
        boolean result = this.addFilename(generator, file);
        if (result) {
            BufferedImageContainer cont = BufferedImageHelper.read((File)file);
            if (cont == null) {
                return false;
            }
            result = this.doProcess(generator, cont.toBufferedImage());
        }
        return result;
    }

    @Override
    public boolean canProcess(PDFGenerator generator, Object obj) {
        return obj instanceof BufferedImage || obj instanceof BufferedImageSupporter;
    }

    @Override
    protected boolean doProcess(PDFGenerator generator, Object obj) throws Exception {
        if (obj instanceof BufferedImage) {
            return this.doProcess(generator, (BufferedImage)obj);
        }
        if (obj instanceof BufferedImageSupporter) {
            return this.doProcess(generator, ((BufferedImageSupporter)obj).toBufferedImage());
        }
        return false;
    }
}

