/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.pdfproclet;

import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.io.TempUtils;
import adams.core.logging.CustomLoggingLevelObject;
import adams.core.management.User;
import adams.data.PageOrientation;
import adams.env.Environment;
import adams.flow.transformer.pdfproclet.AbstractPdfProclet;
import adams.flow.transformer.pdfproclet.DocumentState;
import adams.flow.transformer.pdfproclet.PageSize;
import adams.flow.transformer.pdfproclet.PdfProclet;
import com.itextpdf.text.Document;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class PDFGenerator
extends CustomLoggingLevelObject {
    private static final long serialVersionUID = 8778949995989733244L;
    protected PlaceholderFile m_Output;
    protected PageSize m_PageSize;
    protected PageOrientation m_PageOrientation;
    protected PdfProclet[] m_Proclets;
    protected Document m_Document;
    protected transient FileOutputStream m_Stream;
    protected DocumentState m_State;
    protected PdfWriter m_Writer;

    public PDFGenerator() {
        this.reset();
    }

    protected void reset() {
        this.resetVariables();
        this.resetState();
    }

    protected void resetVariables() {
        this.m_Output = null;
        this.m_PageSize = PageSize.A4;
        this.m_PageOrientation = PageOrientation.PORTRAIT;
        this.m_Proclets = new AbstractPdfProclet[0];
    }

    protected void resetState() {
        this.m_Document = null;
        this.m_State = null;
        this.m_Writer = null;
    }

    public void setPageSize(PageSize value) {
        this.m_PageSize = value;
    }

    public PageSize getPageSize() {
        return this.m_PageSize;
    }

    public void setPageOrientation(PageOrientation value) {
        this.m_PageOrientation = value;
    }

    public PageOrientation getPageOrientation() {
        return this.m_PageOrientation;
    }

    public void setOutput(PlaceholderFile value) {
        this.m_Output = value;
    }

    public PlaceholderFile getOutput() {
        return this.m_Output;
    }

    public void setProclets(PdfProclet[] value) {
        this.m_Proclets = value;
    }

    public PdfProclet[] getProclets() {
        return this.m_Proclets;
    }

    public Document getDocument() {
        return this.m_Document;
    }

    public DocumentState getState() {
        return this.m_State;
    }

    public PdfWriter getWriter() {
        return this.m_Writer;
    }

    public boolean newPage() {
        return this.m_State.newPage(this.m_Document);
    }

    protected Rectangle determinePageSize() {
        Rectangle result;
        switch (this.m_PageSize) {
            case A0: {
                result = com.itextpdf.text.PageSize.A0;
                break;
            }
            case A1: {
                result = com.itextpdf.text.PageSize.A1;
                break;
            }
            case A10: {
                result = com.itextpdf.text.PageSize.A10;
                break;
            }
            case A2: {
                result = com.itextpdf.text.PageSize.A2;
                break;
            }
            case A3: {
                result = com.itextpdf.text.PageSize.A3;
                break;
            }
            case A4: {
                result = com.itextpdf.text.PageSize.A4;
                break;
            }
            case A5: {
                result = com.itextpdf.text.PageSize.A5;
                break;
            }
            case A6: {
                result = com.itextpdf.text.PageSize.A6;
                break;
            }
            case A7: {
                result = com.itextpdf.text.PageSize.A7;
                break;
            }
            case A8: {
                result = com.itextpdf.text.PageSize.A8;
                break;
            }
            case A9: {
                result = com.itextpdf.text.PageSize.A9;
                break;
            }
            case ARCH_A: {
                result = com.itextpdf.text.PageSize.ARCH_A;
                break;
            }
            case ARCH_B: {
                result = com.itextpdf.text.PageSize.ARCH_B;
                break;
            }
            case ARCH_C: {
                result = com.itextpdf.text.PageSize.ARCH_C;
                break;
            }
            case ARCH_D: {
                result = com.itextpdf.text.PageSize.ARCH_D;
                break;
            }
            case ARCH_E: {
                result = com.itextpdf.text.PageSize.ARCH_E;
                break;
            }
            case B0: {
                result = com.itextpdf.text.PageSize.B0;
                break;
            }
            case B1: {
                result = com.itextpdf.text.PageSize.B1;
                break;
            }
            case B10: {
                result = com.itextpdf.text.PageSize.B10;
                break;
            }
            case B2: {
                result = com.itextpdf.text.PageSize.B2;
                break;
            }
            case B3: {
                result = com.itextpdf.text.PageSize.B3;
                break;
            }
            case B4: {
                result = com.itextpdf.text.PageSize.B4;
                break;
            }
            case B5: {
                result = com.itextpdf.text.PageSize.B5;
                break;
            }
            case B6: {
                result = com.itextpdf.text.PageSize.B6;
                break;
            }
            case B7: {
                result = com.itextpdf.text.PageSize.B7;
                break;
            }
            case B8: {
                result = com.itextpdf.text.PageSize.B8;
                break;
            }
            case B9: {
                result = com.itextpdf.text.PageSize.B9;
                break;
            }
            case CROWN_OCTAVO: {
                result = com.itextpdf.text.PageSize.CROWN_OCTAVO;
                break;
            }
            case CROWN_QUARTO: {
                result = com.itextpdf.text.PageSize.CROWN_QUARTO;
                break;
            }
            case DEMY_OCTAVO: {
                result = com.itextpdf.text.PageSize.DEMY_OCTAVO;
                break;
            }
            case DEMY_QUARTO: {
                result = com.itextpdf.text.PageSize.DEMY_QUARTO;
                break;
            }
            case EXECUTIVE: {
                result = com.itextpdf.text.PageSize.EXECUTIVE;
                break;
            }
            case FLSA: {
                result = com.itextpdf.text.PageSize.FLSA;
                break;
            }
            case FLSE: {
                result = com.itextpdf.text.PageSize.FLSE;
                break;
            }
            case HALFLETTER: {
                result = com.itextpdf.text.PageSize.HALFLETTER;
                break;
            }
            case ID_1: {
                result = com.itextpdf.text.PageSize.ID_1;
                break;
            }
            case ID_2: {
                result = com.itextpdf.text.PageSize.ID_2;
                break;
            }
            case ID_3: {
                result = com.itextpdf.text.PageSize.ID_3;
                break;
            }
            case LARGE_CROWN_OCTAVO: {
                result = com.itextpdf.text.PageSize.LARGE_CROWN_OCTAVO;
                break;
            }
            case LARGE_CROWN_QUARTO: {
                result = com.itextpdf.text.PageSize.LARGE_CROWN_QUARTO;
                break;
            }
            case LEDGER: {
                result = com.itextpdf.text.PageSize.LEDGER;
                break;
            }
            case LEGAL: {
                result = com.itextpdf.text.PageSize.LEGAL;
                break;
            }
            case LETTER: {
                result = com.itextpdf.text.PageSize.LETTER;
                break;
            }
            case NOTE: {
                result = com.itextpdf.text.PageSize.NOTE;
                break;
            }
            case PENGUIN_LARGE_PAPERBACK: {
                result = com.itextpdf.text.PageSize.PENGUIN_LARGE_PAPERBACK;
                break;
            }
            case PENGUIN_SMALL_PAPERBACK: {
                result = com.itextpdf.text.PageSize.PENGUIN_SMALL_PAPERBACK;
                break;
            }
            case POSTCARD: {
                result = com.itextpdf.text.PageSize.POSTCARD;
                break;
            }
            case ROYAL_OCTAVO: {
                result = com.itextpdf.text.PageSize.ROYAL_OCTAVO;
                break;
            }
            case ROYAL_QUARTO: {
                result = com.itextpdf.text.PageSize.ROYAL_QUARTO;
                break;
            }
            case SMALL_PAPERBACK: {
                result = com.itextpdf.text.PageSize.SMALL_PAPERBACK;
                break;
            }
            case TABLOID: {
                result = com.itextpdf.text.PageSize.TABLOID;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown page size: " + this.m_PageSize);
            }
        }
        return result;
    }

    public void open() throws Exception {
        this.resetState();
        this.m_Document = this.m_PageOrientation == PageOrientation.PORTRAIT ? new Document(this.determinePageSize()) : new Document(this.determinePageSize().rotate());
        this.m_Stream = new FileOutputStream(this.m_Output.getAbsoluteFile());
        this.m_Writer = PdfWriter.getInstance((Document)this.m_Document, (OutputStream)this.m_Stream);
        this.m_Document.open();
        this.m_Document.addCreationDate();
        this.m_Document.addCreator(Environment.getInstance().getProject());
        this.m_Document.addAuthor(User.getName());
        this.m_State = new DocumentState();
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Opening document: " + this.m_Output);
        }
    }

    public void append() throws Exception {
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Appending document: " + this.m_Output);
        }
        this.resetState();
        File tmpFile = TempUtils.createTempFile((String)"adams", (String)".pdf");
        if (tmpFile.exists() && !tmpFile.delete()) {
            throw new IllegalStateException("Failed to delete temporary PDF file '" + tmpFile + "'!");
        }
        if (!FileUtils.copy((File)this.m_Output, (File)tmpFile)) {
            throw new IllegalStateException("Failed to move original PDF file '" + this.m_Output + "' to '" + tmpFile + "'!");
        }
        PdfReader reader = new PdfReader(tmpFile.getAbsolutePath());
        this.m_Document = reader.getNumberOfPages() > 0 ? new Document(reader.getPageSize(1)) : (this.m_PageOrientation == PageOrientation.PORTRAIT ? new Document(this.determinePageSize()) : new Document(this.determinePageSize().rotate()));
        this.m_Stream = new FileOutputStream(this.m_Output.getAbsoluteFile());
        this.m_Writer = PdfWriter.getInstance((Document)this.m_Document, (OutputStream)this.m_Stream);
        this.m_Document.open();
        this.m_Document.addCreationDate();
        this.m_Document.addCreator(Environment.getInstance().getProject());
        this.m_Document.addAuthor(User.getName());
        this.m_State = new DocumentState();
        PdfContentByte cb = this.m_Writer.getDirectContent();
        for (int i = 0; i < reader.getNumberOfPages(); ++i) {
            PdfImportedPage page = this.m_Writer.getImportedPage(reader, i + 1);
            this.m_Document.newPage();
            cb.addTemplate((PdfTemplate)page, 0.0f, 0.0f);
        }
    }

    protected boolean isOpen() {
        return this.m_Document != null;
    }

    public void addFile(File file) throws Exception {
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Trying to add: " + file);
        }
        boolean processed = false;
        for (PdfProclet proclet : this.m_Proclets) {
            if (!proclet.canProcess(this, file)) continue;
            proclet.process(this, file);
            processed = true;
            if (!this.isLoggingEnabled()) continue;
            this.getLogger().fine("File '" + file + "' processed by: " + proclet.toCommandLine());
        }
        if (!processed) {
            this.getLogger().warning("Unhandled file format - skipped: " + file);
        } else {
            this.getLogger().info("Added successfully: " + file);
        }
    }

    public void addFiles(File[] files) throws Exception {
        for (File file : files) {
            this.addFile(file);
        }
    }

    public void close() {
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Closing document");
        }
        this.m_Document.close();
        FileUtils.closeQuietly((OutputStream)this.m_Stream);
        this.resetState();
    }
}

