/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.pdfproclet;

import adams.core.Utils;
import adams.core.io.PdfFont;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.HeaderRow;
import adams.flow.transformer.pdfproclet.AbstractSpreadSheetPdfProclet;
import adams.flow.transformer.pdfproclet.PDFGenerator;
import com.itextpdf.text.Element;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.List;

public class SpreadSheet
extends AbstractSpreadSheetPdfProclet {
    private static final long serialVersionUID = -5894153152920062499L;
    protected boolean m_AddComments;
    protected PdfFont m_FontComments;
    protected Color m_ColorComments;

    public String globalInfo() {
        return "Adds CSV files (or any spreadsheet files that is supported) as table.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("add-comments", "addComments", (Object)false);
        this.m_OptionManager.add("font-comments", "fontComments", (Object)new PdfFont("Helvetica", "Italic", 12.0f));
        this.m_OptionManager.add("color-comments", "colorComments", (Object)Color.DARK_GRAY);
    }

    public void setAddComments(boolean value) {
        this.m_AddComments = value;
        this.reset();
    }

    public boolean getAddComments() {
        return this.m_AddComments;
    }

    public String addCommentsTipText() {
        return "If enabled, the spreadsheet comments (if any) get added before the table.";
    }

    public void setFontComments(PdfFont value) {
        this.m_FontComments = value;
        this.reset();
    }

    public PdfFont getFontComments() {
        return this.m_FontComments;
    }

    public String fontCommentsTipText() {
        return "The font to use for the comments.";
    }

    public void setColorComments(Color value) {
        this.m_ColorComments = value;
        this.reset();
    }

    public Color getColorComments() {
        return this.m_ColorComments;
    }

    public String colorCommentsTipText() {
        return "The color to use for the comments.";
    }

    @Override
    protected boolean doProcess(PDFGenerator generator, adams.data.spreadsheet.SpreadSheet sheet) throws Exception {
        PdfPCell pdfCell;
        Cell cell;
        boolean result;
        int i;
        Object pattern = "#0";
        for (i = 0; i < this.m_NumDecimals; ++i) {
            if (i == 0) {
                pattern = (String)pattern + ".";
            }
            pattern = (String)pattern + "0";
        }
        DecimalFormat format = new DecimalFormat((String)pattern);
        boolean bl = result = sheet != null;
        if (!result) {
            return false;
        }
        Paragraph paraComments = null;
        if (this.m_AddComments) {
            paraComments = new Paragraph(Utils.flatten((List)sheet.getComments(), (String)"\n"), this.m_FontComments.toFont(this.m_ColorComments));
        }
        PdfPTable table = this.m_RelativeColumnWidths.length == 0 ? new PdfPTable(sheet.getColumnCount()) : new PdfPTable(this.relativeColumnsWidths(sheet));
        table.setWidthPercentage(this.m_WidthPercentage);
        table.setHorizontalAlignment(this.m_HorizontalAlignment.getAlignment());
        table.setHeaderRows(1);
        HeaderRow row = sheet.getHeaderRow();
        for (String key : sheet.getHeaderRow().cellKeys()) {
            cell = row.getCell(key);
            Paragraph para = new Paragraph(cell.toString(), this.m_FontTableHeader.toFont(this.m_ColorTableHeader));
            pdfCell = new PdfPCell((Phrase)para);
            pdfCell.setHorizontalAlignment(0);
            table.addCell(pdfCell);
        }
        for (i = 0; i < sheet.getRowCount(); ++i) {
            row = sheet.getRow(i);
            for (String key : sheet.getHeaderRow().cellKeys()) {
                cell = row.getCell(key);
                if (cell == null || cell.isMissing()) {
                    pdfCell = new PdfPCell((Phrase)new Paragraph(""));
                } else if (cell.getContentType() == Cell.ContentType.LONG) {
                    pdfCell = new PdfPCell((Phrase)new Paragraph(cell.toString(), this.m_FontNumericContent.toFont(this.m_ColorNumericContent)));
                    pdfCell.setHorizontalAlignment(2);
                } else if (cell.isNumeric()) {
                    pdfCell = new PdfPCell((Phrase)new Paragraph(format.format(cell.toDouble()), this.m_FontNumericContent.toFont(this.m_ColorNumericContent)));
                    pdfCell.setHorizontalAlignment(2);
                } else {
                    pdfCell = new PdfPCell((Phrase)new Paragraph(cell.toString(), this.m_FontGeneralContent.toFont(this.m_ColorGeneralContent)));
                    pdfCell.setHorizontalAlignment(0);
                }
                table.addCell(pdfCell);
            }
        }
        if (this.m_UseAbsolutePosition) {
            ColumnText ct = this.addColumnTextAt(generator, this.m_X, this.m_Y);
            if (paraComments != null) {
                ct.addElement((Element)paraComments);
                ct.addElement((Element)new Paragraph("\n"));
            }
            ct.addElement((Element)new Paragraph("\n"));
            ct.addElement((Element)table);
            ct.go();
            generator.getState().contentAdded();
        } else {
            if (paraComments != null && (result = this.addElement(generator, (Element)paraComments))) {
                result = this.addElement(generator, (Element)new Paragraph("\n"));
            }
            if (result) {
                result = this.addElement(generator, (Element)new Paragraph("\n"));
            }
            if (result) {
                result = this.addElement(generator, (Element)table);
            }
        }
        return result;
    }
}

