/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.sendto;

import adams.core.io.IcePDF;
import adams.core.io.PDFBox;
import adams.core.io.PlaceholderFile;
import adams.gui.sendto.AbstractSendToAction;
import adams.gui.sendto.SendToActionUtils;
import java.io.File;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.icepdf.core.pobjects.Document;

public class PDFPrinter
extends AbstractSendToAction {
    private static final long serialVersionUID = -6357616730945070639L;

    public String getAction() {
        return "Printer (PDF)";
    }

    public String getIconName() {
        return "print.gif";
    }

    public Class[] accepts() {
        return new Class[]{Document.class, PDDocument.class};
    }

    public String send(Object o) {
        Object result = null;
        if (o instanceof Document) {
            PlaceholderFile file = SendToActionUtils.nextTmpFile((String)"pdfviewer", (String)"pdf");
            String msg = IcePDF.saveTo((Document)o, (File)file);
            if (msg == null) {
                if (!PDFBox.printWithDialog((File)file)) {
                    result = "Failed to print PDF document: " + (File)file;
                }
            } else {
                result = "Failed to save PDF document to: " + (File)file + "\n" + msg;
            }
        } else if (o instanceof PDDocument) {
            if (!PDFBox.print((PDDocument)o)) {
                result = "Failed to print PDF document";
            }
        } else {
            result = "Cannot print object: " + o.getClass();
        }
        return result;
    }
}

