/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.pdf;

import adams.core.CleanUpHandler;
import adams.core.io.IcePDF;
import adams.gui.core.BasePanel;
import java.awt.BorderLayout;
import java.io.File;
import javax.swing.JPanel;
import org.icepdf.core.pobjects.Document;
import org.icepdf.ri.common.MyAnnotationCallback;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.SwingViewBuilder;
import org.icepdf.ri.common.views.AnnotationCallback;
import org.icepdf.ri.util.FontPropertiesManager;
import org.icepdf.ri.util.ViewerPropertiesManager;

public class PDFPanel
extends BasePanel
implements CleanUpHandler {
    private static final long serialVersionUID = -1994121429485824895L;
    protected SwingController m_Controller;
    protected JPanel m_ViewerComponentPanel;
    protected boolean m_HasDocument;

    protected void initialize() {
        super.initialize();
        this.m_HasDocument = false;
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Controller = new SwingController();
        this.m_Controller.setIsEmbeddedComponent(true);
        FontPropertiesManager.getInstance().loadOrReadSystemFonts();
        ViewerPropertiesManager properties = ViewerPropertiesManager.getInstance();
        properties.getPreferences().putFloat("application.zoom.factor.default", 1.25f);
        SwingViewBuilder factory = new SwingViewBuilder(this.m_Controller, properties);
        this.m_Controller.getDocumentViewController().setAnnotationCallback((AnnotationCallback)new MyAnnotationCallback(this.m_Controller.getDocumentViewController()));
        this.m_ViewerComponentPanel = factory.buildViewerPanel();
        this.add(this.m_ViewerComponentPanel, "Center");
    }

    public void setDocument(String filename) {
        this.m_Controller.closeDocument();
        this.m_Controller.openDocument(filename);
        this.m_HasDocument = true;
    }

    public void setDocument(File file) {
        this.setDocument(file.getAbsolutePath());
    }

    public Document getDocument() {
        return this.m_Controller.getDocument();
    }

    public void closeDocument() {
        this.m_HasDocument = false;
        this.m_Controller.closeDocument();
    }

    public void setScale(double value) {
        this.m_Controller.setZoom((float)value);
    }

    public double getScale() {
        return this.m_Controller.getDocumentViewController().getZoom();
    }

    public boolean hasDocument() {
        return this.m_HasDocument;
    }

    public String saveTo(File file) {
        if (!this.m_HasDocument) {
            return null;
        }
        return IcePDF.saveTo(this.getDocument(), file);
    }

    public void print(boolean withDialog) {
        this.m_Controller.print(withDialog);
    }

    public void cleanUp() {
        this.closeDocument();
    }
}

