/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.pdf;

import adams.core.Properties;
import adams.core.io.PlaceholderFile;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.GUIHelper;
import adams.gui.core.ImageManager;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.RecentFilesHandler;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import adams.gui.visualization.pdf.PDFPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.icepdf.core.pobjects.Document;

public class PDFViewerPanel
extends BasePanel
implements MenuBarProvider,
SendToActionSupporter {
    private static final long serialVersionUID = 1270944412770632645L;
    public static final String SESSION_FILE = "PDFViewerSession.props";
    protected static Properties m_Properties;
    protected MultiPagePane m_MultiPagePane;
    protected JMenuBar m_MenuBar;
    protected JMenuItem m_MenuItemFileOpen;
    protected JMenu m_MenuItemFileOpenRecent;
    protected JMenuItem m_MenuItemFileClose;
    protected JMenuItem m_MenuItemFilePrint;
    protected JMenuItem m_MenuItemFileExit;
    protected transient BaseFileChooser m_FileChooser;
    protected RecentFilesHandler<JMenu> m_RecentFilesHandler;

    protected void initialize() {
        super.initialize();
        this.m_RecentFilesHandler = null;
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_MultiPagePane = new MultiPagePane();
        this.add((Component)((Object)this.m_MultiPagePane), "Center");
    }

    protected BaseFileChooser getFileChooser() {
        if (this.m_FileChooser == null) {
            BaseFileChooser fileChooser = new BaseFileChooser();
            fileChooser.addChoosableFileFilter((FileFilter)ExtensionFileFilter.getPdfFileFilter());
            fileChooser.setDefaultExtension(ExtensionFileFilter.getPdfFileFilter().getExtensions()[0]);
            fileChooser.setMultiSelectionEnabled(true);
            this.m_FileChooser = fileChooser;
        }
        return this.m_FileChooser;
    }

    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PDFViewerPanel.this.updateMenu();
                }
            });
            JMenuItem menuitem = new JMenuItem("Open...");
            menu.add(menuitem);
            menuitem.setMnemonic('O');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed O"));
            menuitem.setIcon(ImageManager.getIcon((String)"open.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PDFViewerPanel.this.open();
                }
            });
            this.m_MenuItemFileOpen = menuitem;
            JMenu submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentFilesHandler = new RecentFilesHandler(SESSION_FILE, 5, (Object)submenu);
            this.m_RecentFilesHandler.addRecentItemListener((RecentItemListener)new RecentItemListener<JMenu, File>(){

                public void recentItemAdded(RecentItemEvent<JMenu, File> e) {
                }

                public void recentItemSelected(RecentItemEvent<JMenu, File> e) {
                    PDFViewerPanel.this.load((File)e.getItem());
                }
            });
            this.m_MenuItemFileOpenRecent = submenu;
            menuitem = new JMenuItem("Close tab");
            menu.add(menuitem);
            menuitem.setMnemonic('t');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed W"));
            menuitem.setIcon(ImageManager.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PDFViewerPanel.this.closeFile();
                }
            });
            this.m_MenuItemFileClose = menuitem;
            menu.addSeparator();
            menuitem = new JMenuItem("Print...");
            menu.add(menuitem);
            menuitem.setMnemonic('P');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed P"));
            menuitem.setIcon(ImageManager.getIcon((String)"print.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PDFViewerPanel.this.printFile();
                }
            });
            this.m_MenuItemFilePrint = menuitem;
            menu.addSeparator();
            if (SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, (JMenu)menu)) {
                menu.addSeparator();
            }
            menuitem = new JMenuItem("Close");
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Q"));
            menuitem.setIcon(ImageManager.getIcon((String)"exit.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PDFViewerPanel.this.close();
                }
            });
            this.m_MenuItemFileExit = menuitem;
            this.m_MenuBar = result;
            this.updateMenu();
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    public PDFPanel getCurrentPanel() {
        PDFPanel result = null;
        int index = this.m_MultiPagePane.getSelectedIndex();
        if (index >= 0) {
            result = (PDFPanel)((Object)this.m_MultiPagePane.getPageAt(index));
        }
        return result;
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        boolean pdfAvailable = this.m_MultiPagePane.getPageCount() > 0 && this.m_MultiPagePane.getSelectedIndex() != -1;
        this.m_MenuItemFileClose.setEnabled(pdfAvailable);
        this.m_MenuItemFilePrint.setEnabled(pdfAvailable);
    }

    protected void open() {
        PlaceholderFile[] files;
        int retVal = this.getFileChooser().showOpenDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        for (PlaceholderFile file : files = this.getFileChooser().getSelectedPlaceholderFiles()) {
            this.load((File)file);
        }
    }

    public void load(File file) {
        PDFPanel panel = new PDFPanel();
        panel.setDocument(file);
        this.m_MultiPagePane.addPage(file.getName(), (Component)((Object)panel));
        this.m_MultiPagePane.setSelectedIndex(this.m_MultiPagePane.getPageCount() - 1);
        this.getFileChooser().setCurrentDirectory(file.getParentFile().getAbsoluteFile());
        if (this.m_RecentFilesHandler != null) {
            this.m_RecentFilesHandler.addRecentItem((Object)file);
        }
    }

    protected void closeFile() {
        int index = this.m_MultiPagePane.getSelectedIndex();
        if (index == -1) {
            return;
        }
        this.m_MultiPagePane.getPanelAt(index).closeDocument();
        this.m_MultiPagePane.remove(index);
    }

    protected void printFile() {
        int index = this.m_MultiPagePane.getSelectedIndex();
        if (index == -1) {
            return;
        }
        this.m_MultiPagePane.getPanelAt(index).print(true);
    }

    protected void close() {
        this.closeParent();
    }

    protected void zoom(int zoom) {
        this.getCurrentPanel().setScale((double)zoom / 100.0);
    }

    public Class[] getSendToClasses() {
        return new Class[]{PlaceholderFile.class, Document.class};
    }

    public boolean hasSendToItem(Class[] cls) {
        return (SendToActionUtils.isAvailable(PlaceholderFile.class, (Class[])cls) || SendToActionUtils.isAvailable(Document.class, (Class[])cls)) && this.getCurrentPanel() != null && this.getCurrentPanel().getDocument() != null;
    }

    public Object getSendToItem(Class[] cls) {
        PlaceholderFile result = null;
        if (SendToActionUtils.isAvailable(PlaceholderFile.class, (Class[])cls)) {
            if (this.getCurrentPanel().getDocument() != null) {
                result = SendToActionUtils.nextTmpFile((String)"pdfviewer", (String)"pdf");
                String msg = this.getCurrentPanel().saveTo((File)result);
                if (msg != null) {
                    System.err.println("Failed to save PDF to '" + result + "':\n" + msg);
                    result = null;
                }
            }
        } else if (SendToActionUtils.isAvailable(PDDocument.class, (Class[])cls)) {
            result = this.getCurrentPanel().getDocument();
        }
        return result;
    }

    public static class MultiPagePane
    extends adams.gui.core.MultiPagePane {
        private static final long serialVersionUID = -2048229771213837710L;

        public PDFPanel getPanelAt(int index) {
            PDFPanel result;
            if (this.getPageAt(index) instanceof JScrollPane) {
                JScrollPane pane = (JScrollPane)this.getPageAt(index);
                result = (PDFPanel)((Object)pane.getViewport().getView());
            } else {
                result = (PDFPanel)((Object)this.getPageAt(index));
            }
            return result;
        }
    }
}

