/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * AbstractGlobalPHMMClassifierEvaluator.java
 * Copyright (C) 2009-2013 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.flow.core.GlobalActorHelper;
import adams.flow.core.GlobalActorReference;

/**
 * Ancestor for classifier evaluators that make use of a global PHMM classifier.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 8135 $
 */
public abstract class AbstractGlobalPHMMClassifierEvaluator<T extends weka.classifiers.Classifier>
  extends AbstractWekaClassifierEvaluator {

  /** for serialization. */
  private static final long serialVersionUID = 9216099627972841132L;

  /** the name of the global PHMM classifier. */
  protected GlobalActorReference m_Classifier;

  /**
   * Adds options to the internal list of options.
   */
  @Override
  public void defineOptions() {
    super.defineOptions();

    m_OptionManager.add(
	    "classifier", "classifier",
	    new GlobalActorReference("PHMMClassifier"));
  }

  /**
   * Sets the name of the global classifier to use.
   *
   * @param value	the name
   */
  public void setClassifier(GlobalActorReference value) {
    m_Classifier = value;
    reset();
  }

  /**
   * Returns the name of the global classifier in use.
   *
   * @return		the name
   */
  public GlobalActorReference getClassifier() {
    return m_Classifier;
  }

  /**
   * Returns the tip text for this property.
   *
   * @return 		tip text for this property suitable for
   * 			displaying in the GUI or for listing the options.
   */
  public abstract String classifierTipText();

  /**
   * Returns a quick info about the actor, which will be displayed in the GUI.
   *
   * @return		null if no info available, otherwise short string
   */
  @Override
  public String getQuickInfo() {
    return QuickInfoHelper.toString(this, "classifier", m_Classifier);
  }

  /**
   * Returns an instance of the global classifier.
   *
   * @return		the classifier
   */
  protected T getClassifierInstance() {
    return (T) GlobalActorHelper.getSetup(null, m_Classifier, this);
  }
}
