/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.BaseHostname;
import adams.core.io.FileUtils;
import adams.core.logging.LoggingSupporter;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.RunnableWithLogging;
import adams.flow.standalone.AbstractStandalone;
import adams.flow.standalone.PythonEnvironment;
import com.github.fracpete.processoutput4j.core.StreamingProcessOutputType;
import com.github.fracpete.processoutput4j.core.StreamingProcessOwner;
import com.github.fracpete.processoutput4j.output.StreamingProcessOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import net.razorvine.pyro.Config;
import net.razorvine.pyro.NameServerProxy;

public class PyroNameServer
extends AbstractStandalone
implements StreamingProcessOwner {
    private static final long serialVersionUID = 5148275104228911234L;
    public static final String EXECUTABLE = "pyro4-ns";
    protected BaseHostname m_Server;
    protected Mode m_Mode;
    protected String m_LaunchModeOptions;
    protected int m_LaunchWait;
    protected transient NameServerProxy m_NameServer;
    protected transient String m_NameServerExecutable;
    protected transient PythonEnvironment m_Environment;
    protected transient StreamingProcessOutput m_ProcessOutput;
    protected RunnableWithLogging m_Monitor;
    protected IllegalStateException m_ExecutionFailure;

    public String globalInfo() {
        return "Defines the Pyro nameserver to use.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("server", "server", (Object)new BaseHostname("localhost:9090"));
        this.m_OptionManager.add("mode", "mode", (Object)Mode.CONNECT);
        this.m_OptionManager.add("launch-mode-options", "launchModeOptions", (Object)"");
        this.m_OptionManager.add("launch-wait", "launchWait", (Object)1000, (Number)0, null);
    }

    protected void reset() {
        super.reset();
        this.m_NameServer = null;
        this.m_NameServerExecutable = null;
    }

    public void setServer(BaseHostname value) {
        this.m_Server = value;
        this.reset();
    }

    public BaseHostname getServer() {
        return this.m_Server;
    }

    public String serverTipText() {
        return "The hostname and port of the nameserver to connect to (and/or launch).";
    }

    public void setMode(Mode value) {
        this.m_Mode = value;
        this.reset();
    }

    public Mode getMode() {
        return this.m_Mode;
    }

    public String modeTipText() {
        return "How to operate, eg simply using or also launching.";
    }

    public void setLaunchModeOptions(String value) {
        this.m_LaunchModeOptions = value;
        this.reset();
    }

    public String getLaunchModeOptions() {
        return this.m_LaunchModeOptions;
    }

    public String launchModeOptionsTipText() {
        return "The additional options to use for the nameserver (aside hostname and port).";
    }

    public void setLaunchWait(int value) {
        this.m_LaunchWait = value;
        this.reset();
    }

    public int getLaunchWait() {
        return this.m_LaunchWait;
    }

    public String launchWaitTipText() {
        return "The number of milliseconds to wait for the nameserver to become operational (and check for potential errors); disabled if 0.";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"server", (Object)this.m_Server, (String)"server: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"mode", (Object)((Object)this.m_Mode), (String)", mode: ");
        if (this.m_Mode == Mode.LAUNCH_AND_CONNECT) {
            result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"launchModeOptions", (Object)(this.m_LaunchModeOptions.isEmpty() ? "-none-" : this.m_LaunchModeOptions), (String)", launch options: ");
        }
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"launchWait", (Object)this.m_LaunchWait, (String)", wait: ");
        return result;
    }

    public NameServerProxy getNameServer() {
        return this.m_NameServer;
    }

    public String getNameServerExecutable() {
        return this.m_NameServerExecutable;
    }

    public StreamingProcessOutputType getOutputType() {
        return StreamingProcessOutputType.BOTH;
    }

    public void processOutput(String line, boolean stdout) {
        if (stdout) {
            this.getLogger().info("[NS-OUT] " + line);
        } else {
            this.getLogger().warning("[NS-ERR] " + line);
        }
    }

    protected void launch() throws Exception {
        if (this.m_Environment == null) {
            throw new IllegalStateException("No python environment present!");
        }
        if (this.m_NameServerExecutable == null) {
            this.m_NameServerExecutable = this.m_Environment.getActualBinDir() + File.separator + FileUtils.fixExecutable((String)EXECUTABLE);
        }
        if (!FileUtils.fileExists((String)this.m_NameServerExecutable)) {
            throw new IllegalStateException("Pyro nameserver executable not found: " + this.m_NameServerExecutable);
        }
        final ArrayList<Object> cmd = new ArrayList<Object>();
        cmd.add(this.m_NameServerExecutable);
        cmd.add("-n");
        cmd.add(this.m_Server.hostnameValue());
        cmd.add("-p");
        cmd.add("" + this.m_Server.portValue(Config.NS_PORT));
        if (!this.m_LaunchModeOptions.trim().isEmpty()) {
            cmd.addAll(Arrays.asList(OptionUtils.splitOptions((String)this.m_LaunchModeOptions)));
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Launching: " + OptionUtils.joinOptions((String[])cmd.toArray(new String[0])));
        }
        this.m_ExecutionFailure = null;
        this.m_ProcessOutput = new StreamingProcessOutput((StreamingProcessOwner)this);
        this.m_Monitor = new RunnableWithLogging(){
            private static final long serialVersionUID = -4475355379511760429L;

            protected void doRun() {
                try {
                    ProcessBuilder builder = new ProcessBuilder(cmd);
                    PyroNameServer.this.m_Environment.updatePythonPath(builder.environment());
                    PyroNameServer.this.m_ProcessOutput.monitor(builder);
                    if (PyroNameServer.this.m_ProcessOutput.getExitCode() > 0) {
                        PyroNameServer.this.m_ExecutionFailure = new IllegalStateException("Failed to execute: " + OptionUtils.joinOptions((String[])cmd.toArray(new String[0])) + "\nExit code: " + PyroNameServer.this.m_ProcessOutput.getExitCode());
                    }
                }
                catch (Exception e) {
                    PyroNameServer.this.m_ExecutionFailure = new IllegalStateException("Failed to execute: " + OptionUtils.joinOptions((String[])cmd.toArray(new String[0])), e);
                }
                PyroNameServer.this.m_Monitor = null;
                PyroNameServer.this.m_ProcessOutput = null;
            }

            public void stopExecution() {
                if (PyroNameServer.this.m_ProcessOutput != null) {
                    PyroNameServer.this.m_ProcessOutput.destroy();
                }
                super.stopExecution();
            }
        };
        new Thread((Runnable)this.m_Monitor).start();
        if (this.m_LaunchWait > 0) {
            Utils.wait((LoggingSupporter)this, (int)this.m_LaunchWait, (int)100);
            if (this.m_ExecutionFailure != null) {
                throw this.m_ExecutionFailure;
            }
        }
    }

    protected void connect() throws IOException {
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Connecting to: " + this.m_Server);
        }
        this.m_NameServer = NameServerProxy.locateNS((String)this.m_Server.hostnameValue(), (int)this.m_Server.portValue(Config.NS_PORT), null);
    }

    protected void disconnect() {
        if (this.m_NameServer != null) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Disconnecting from: " + this.m_Server);
            }
            this.m_NameServer.close();
        }
    }

    public String setUp() {
        Object result = super.setUp();
        if (result == null && this.m_Mode == Mode.LAUNCH_AND_CONNECT) {
            this.m_Environment = (PythonEnvironment)ActorUtils.findClosestType((Actor)this, PythonEnvironment.class, (boolean)true);
            if (this.m_Environment == null) {
                result = "Failed to locate a " + Utils.classToString(PythonEnvironment.class) + " actor!";
            }
        }
        return result;
    }

    protected String doExecute() {
        Object result = null;
        try {
            switch (this.m_Mode) {
                case CONNECT: {
                    this.disconnect();
                    this.connect();
                    break;
                }
                case LAUNCH_AND_CONNECT: {
                    this.disconnect();
                    this.launch();
                    if (!this.isStopped() && this.m_Monitor != null) {
                        this.connect();
                    }
                    break;
                }
                default: {
                    result = "Unhandled mode: " + this.m_Mode;
                    break;
                }
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to connect to nameserver: " + this.m_Server, e);
        }
        return result;
    }

    public void stopExecution() {
        if (this.m_Monitor != null) {
            this.m_Monitor.stopExecution();
        }
        super.stopExecution();
    }

    public void wrapUp() {
        if (this.m_Monitor != null) {
            this.m_Monitor.stopExecution();
        }
        this.disconnect();
        super.wrapUp();
    }

    public static enum Mode {
        CONNECT,
        LAUNCH_AND_CONNECT;

    }
}

