/*
 * Decompiled with CFR 0.152.
 */
package adams.data.wekapyroproxy;

import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.core.base.BaseString;
import adams.data.wekapyroproxy.AbstractCommunicationProcessor;
import com.github.fracpete.javautils.Enumerate;
import com.github.fracpete.javautils.enumerate.Enumerated;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import weka.classifiers.functions.PyroProxy;
import weka.core.Instance;
import weka.core.Instances;

public class FusionJsonCommunicationProcessor
extends AbstractCommunicationProcessor {
    private static final long serialVersionUID = -704870273976903924L;
    protected BaseRegExp[] m_RegExps;
    protected BaseString[] m_Names;
    protected Map<BaseString, TIntList> m_Mapping;
    protected String m_ClassAttName;

    public String globalInfo() {
        return "Turns Instances/Instance into fusion JSON.\nUses regular expressions to identify the fusion subsets (incl the class attribute).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("regexp", "regExps", (Object)new BaseRegExp[0]);
        this.m_OptionManager.add("name", "names", (Object)new BaseString[0]);
    }

    public void setRegExps(BaseRegExp[] value) {
        this.m_RegExps = value;
        this.m_Names = (BaseString[])Utils.adjustArray((Object)this.m_Names, (int)this.m_RegExps.length, (Object)new BaseString());
        this.reset();
    }

    public BaseRegExp[] getRegExps() {
        return this.m_RegExps;
    }

    public String regExpsTipText() {
        return "The regular expressions to use for identifying the fusion subsets (incl the class attribute).";
    }

    public void setNames(BaseString[] value) {
        this.m_Names = value;
        this.m_RegExps = (BaseRegExp[])Utils.adjustArray((Object)this.m_RegExps, (int)this.m_Names.length, (Object)new BaseRegExp());
        this.reset();
    }

    public BaseString[] getNames() {
        return this.m_Names;
    }

    public String namesTipText() {
        return "The names to use for the fusion subsets (corresponds to the subsets).";
    }

    @Override
    protected void doInitialize(PyroProxy owner, Instances data) throws Exception {
        if (this.m_RegExps.length != this.m_Names.length) {
            throw new IllegalStateException("# of regexps and names differ: " + this.m_RegExps.length + " != " + this.m_Names.length);
        }
        if (this.m_RegExps.length == 0) {
            throw new IllegalStateException("No regular expressions defined!");
        }
        if (data.classIndex() == -1) {
            throw new IllegalStateException("No class attribute set!");
        }
        this.m_ClassAttName = data.classAttribute().name();
        this.m_Mapping = new HashMap<BaseString, TIntList>();
        for (BaseString name : this.m_Names) {
            this.m_Mapping.put(name, (TIntList)new TIntArrayList());
        }
        for (int i = 0; i < data.numAttributes(); ++i) {
            for (Enumerated regExp : Enumerate.enumerate((Object[])this.m_RegExps)) {
                if (!((BaseRegExp)regExp.value).isMatch(data.attribute(i).name())) continue;
                this.m_Mapping.get(this.m_Names[regExp.index]).add(i);
                if (data.attribute(i).isNumeric()) continue;
                throw new IllegalStateException("Attribute #" + (i + 1) + " (" + data.attribute(i).name() + ") is not numeric!");
            }
        }
        for (Enumerated name : Enumerate.enumerate((Object[])this.m_Names)) {
            if (!this.m_Mapping.get(name.value).isEmpty()) continue;
            throw new IllegalStateException("Regular expression '" + this.m_RegExps[name.index] + "' (" + name.value + ") did not match any attributes!");
        }
    }

    protected JSONArray instanceToRow(Instance inst, BaseString name) {
        JSONArray result = new JSONArray();
        for (int index : this.m_Mapping.get(name).toArray()) {
            result.add((Object)inst.value(index));
        }
        return result;
    }

    @Override
    protected Object doConvertDataset(PyroProxy owner, Instances data) throws Exception {
        JSONObject result = new JSONObject();
        JSONArray names = new JSONArray();
        names.add((Object)owner.getModelName());
        result.put((Object)"names", (Object)names);
        result.put((Object)"names-are-tags", (Object)false);
        JSONObject inputs = new JSONObject();
        result.put((Object)"inputs", (Object)inputs);
        for (BaseString name : this.m_Names) {
            JSONArray input = new JSONArray();
            inputs.put((Object)name.getValue(), (Object)input);
            for (int i = 0; i < data.numInstances(); ++i) {
                input.add((Object)this.instanceToRow(data.instance(i), name));
            }
        }
        return result.toJSONString();
    }

    @Override
    protected Object doConvertInstance(PyroProxy owner, Instance inst) throws Exception {
        JSONObject result = new JSONObject();
        JSONArray names = new JSONArray();
        names.add((Object)owner.getModelName());
        result.put((Object)"names", (Object)names);
        result.put((Object)"names-are-tags", (Object)false);
        JSONObject inputs = new JSONObject();
        result.put((Object)"inputs", (Object)inputs);
        for (BaseString name : this.m_Names) {
            JSONArray input = new JSONArray();
            inputs.put((Object)name.getValue(), (Object)input);
            input.add((Object)this.instanceToRow(inst, name));
        }
        return result.toJSONString();
    }

    @Override
    protected double[] doParsePrediction(PyroProxy owner, Object prediction) throws Exception {
        JSONParser parser = new JSONParser(1984);
        StringReader sreader = new StringReader((String)prediction);
        JSONObject parsed = (JSONObject)parser.parse((Reader)sreader);
        if (parsed.containsKey((Object)"error")) {
            throw new Exception(parsed.getAsString("error"));
        }
        JSONObject outputs = (JSONObject)parsed.get((Object)"outputs");
        if (outputs == null) {
            throw new IllegalStateException("Failed to retrieve key: outputs");
        }
        JSONObject model = (JSONObject)outputs.get((Object)owner.getModelName());
        if (model == null) {
            throw new IllegalStateException("Failed to retrieve model: " + owner.getModelName());
        }
        JSONArray output = (JSONArray)model.get((Object)this.m_ClassAttName);
        if (output == null) {
            throw new IllegalStateException("Failed to retrieve predictions for class attribute: " + this.m_ClassAttName);
        }
        if (output.size() == 0) {
            throw new IllegalStateException("Outer predictions array is empty!");
        }
        JSONArray outputElem = (JSONArray)output.get(0);
        if (outputElem.size() == 0) {
            throw new IllegalStateException("Inner predictions array is empty!");
        }
        double[] result = new double[]{((Number)outputElem.get(0)).doubleValue()};
        return result;
    }

    @Override
    public boolean supportsBatchPredictions() {
        return true;
    }

    @Override
    protected double[][] doParsePredictions(PyroProxy owner, Object predictions) throws Exception {
        JSONParser parser = new JSONParser(1984);
        StringReader sreader = new StringReader((String)predictions);
        JSONObject parsed = (JSONObject)parser.parse((Reader)sreader);
        if (parsed.containsKey((Object)"error")) {
            throw new Exception(parsed.getAsString("error"));
        }
        JSONObject outputs = (JSONObject)parsed.get((Object)"outputs");
        if (outputs == null) {
            throw new IllegalStateException("Failed to retrieve key: outputs");
        }
        JSONObject model = (JSONObject)outputs.get((Object)owner.getModelName());
        if (model == null) {
            throw new IllegalStateException("Failed to retrieve model: " + owner.getModelName());
        }
        JSONArray output = (JSONArray)model.get((Object)this.m_ClassAttName);
        if (output == null) {
            throw new IllegalStateException("Failed to retrieve predictions for class attribute: " + this.m_ClassAttName);
        }
        if (output.size() == 0) {
            throw new IllegalStateException("Outer predictions array is empty!");
        }
        double[][] result = new double[output.size()][];
        for (int i = 0; i < output.size(); ++i) {
            JSONArray outputElem = (JSONArray)output.get(i);
            if (outputElem.size() == 0) {
                throw new IllegalStateException("Inner predictions array #" + (i + 1) + " is empty!");
            }
            result[i] = new double[]{((Number)outputElem.get(0)).doubleValue()};
        }
        return result;
    }
}

