/*
 * Decompiled with CFR 0.152.
 */
package adams.data.wekapyroproxy;

import adams.core.exception.NotImplementedException;
import adams.data.wekapyroproxy.AbstractCommunicationProcessor;
import java.io.Reader;
import java.io.StringReader;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import weka.classifiers.functions.PyroProxy;
import weka.core.Instance;
import weka.core.Instances;

public class SimpleJsonCommunicationProcessor
extends AbstractCommunicationProcessor {
    private static final long serialVersionUID = -704870273976903924L;

    public String globalInfo() {
        return "Turns Instances/Instance into simple JSON.";
    }

    @Override
    protected void doInitialize(PyroProxy owner, Instances data) throws Exception {
        for (int i = 0; i < data.numAttributes(); ++i) {
            if (data.attribute(i).isNumeric()) continue;
            throw new IllegalStateException("Attribute #" + (i + 1) + " (" + data.attribute(i).name() + ") is not numeric!");
        }
    }

    protected JSONArray instanceToRow(Instance inst) {
        JSONArray result = new JSONArray();
        for (int i = 0; i < inst.numAttributes(); ++i) {
            if (i == inst.classIndex()) continue;
            result.add((Object)inst.value(i));
        }
        return result;
    }

    @Override
    protected Object doConvertDataset(PyroProxy owner, Instances data) throws Exception {
        JSONObject result = new JSONObject();
        result.put((Object)"Model", (Object)owner.getModelName());
        JSONObject train = new JSONObject();
        result.put((Object)"Train", (Object)train);
        JSONArray x = new JSONArray();
        train.put((Object)"X", (Object)x);
        JSONArray y = new JSONArray();
        train.put((Object)"y", (Object)y);
        for (int i = 0; i < data.numInstances(); ++i) {
            x.add((Object)this.instanceToRow(data.instance(i)));
            y.add((Object)data.instance(i).classValue());
        }
        return result.toJSONString();
    }

    @Override
    protected Object doConvertInstance(PyroProxy owner, Instance inst) throws Exception {
        JSONObject result = new JSONObject();
        result.put((Object)"Model", (Object)owner.getModelName());
        result.put((Object)"x", (Object)this.instanceToRow(inst));
        return result.toJSONString();
    }

    @Override
    protected double[] doParsePrediction(PyroProxy owner, Object prediction) throws Exception {
        JSONParser parser = new JSONParser(1984);
        StringReader sreader = new StringReader((String)prediction);
        JSONObject pred = (JSONObject)parser.parse((Reader)sreader);
        if (pred.containsKey((Object)"Error")) {
            throw new Exception(pred.getAsString("Error"));
        }
        JSONArray array = (JSONArray)pred.get((Object)"Prediction");
        double[] result = new double[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            result[i] = ((Number)array.get(i)).doubleValue();
        }
        return result;
    }

    @Override
    public boolean supportsBatchPredictions() {
        return false;
    }

    @Override
    protected double[][] doParsePredictions(PyroProxy owner, Object predictions) throws Exception {
        throw new NotImplementedException();
    }
}

