/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.BaseString;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.standalone.AbstractStandalone;
import java.io.File;
import java.util.Map;

public class PythonEnvironment
extends AbstractStandalone {
    private static final long serialVersionUID = 5148275104228911234L;
    public static final String PYTHONPATH = "PYTHONPATH";
    protected BaseString[] m_PythonPathEnvVar;
    protected PythonPathUpdateType m_PythonPathUpdateType;
    protected String m_ActualPythonPath;
    protected PlaceholderFile m_Python;
    protected String m_ActualPython;
    protected PlaceholderFile m_Pip;
    protected String m_ActualPip;
    protected String m_Suffix;

    public String globalInfo() {
        return "Defines what Python executables to use within this context.\nOn Linux, you can enforce using the system-wide Python 3 executables by supplying '3' as suffix, which gets appended to the executables.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("python-path-env-var", "pythonPathEnvVar", (Object)new BaseString[0]);
        this.m_OptionManager.add("python-path-update-type", "pythonPathUpdateType", (Object)PythonPathUpdateType.NO_UPDATE);
        this.m_OptionManager.add("python", "python", (Object)new PlaceholderFile());
        this.m_OptionManager.add("pip", "pip", (Object)new PlaceholderFile());
        this.m_OptionManager.add("suffix", "suffix", (Object)"");
    }

    protected void reset() {
        super.reset();
        this.m_ActualPythonPath = null;
        this.m_ActualPython = null;
        this.m_ActualPip = null;
    }

    public void setPythonPathEnvVar(BaseString[] value) {
        this.m_PythonPathEnvVar = value;
        this.reset();
    }

    public BaseString[] getPythonPathEnvVar() {
        return this.m_PythonPathEnvVar;
    }

    public String pythonPathEnvVarTipText() {
        return "The paths to use for the PYTHONPATH environment variable.";
    }

    public void setPythonPathUpdateType(PythonPathUpdateType value) {
        this.m_PythonPathUpdateType = value;
        this.reset();
    }

    public PythonPathUpdateType getPythonPathUpdateType() {
        return this.m_PythonPathUpdateType;
    }

    public String pythonPathUpdateTypeTipText() {
        return "Determines how to update the PYTHONPATH environment variable.";
    }

    public void setPython(PlaceholderFile value) {
        this.m_Python = value;
        this.reset();
    }

    public PlaceholderFile getPython() {
        return this.m_Python;
    }

    public String pythonTipText() {
        return "The python executable, uses one on path if pointing to a directory.";
    }

    public void setPip(PlaceholderFile value) {
        this.m_Pip = value;
        this.reset();
    }

    public PlaceholderFile getPip() {
        return this.m_Pip;
    }

    public String pipTipText() {
        return "The pip executable, uses one on path if pointing to a directory.";
    }

    public void setSuffix(String value) {
        this.m_Suffix = value;
        this.reset();
    }

    public String getSuffix() {
        return this.m_Suffix;
    }

    public String suffixTipText() {
        return "The suffix (not extension!) to append to the executable when using the system-wide ones; eg on Linux use '3' to enforce Python 3.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"python", (Object)(this.m_Python.isDirectory() ? "-system-" : this.m_Python.toString()), (String)"python: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"pip", (Object)(this.m_Pip.isDirectory() ? "-system-" : this.m_Pip.toString()), (String)", pip: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"suffix", (Object)(this.m_Suffix.isEmpty() ? "-none-" : this.m_Suffix), (String)", suffix: ");
        if (this.m_PythonPathUpdateType != PythonPathUpdateType.NO_UPDATE) {
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"pythonPathUpdateType", (Object)((Object)this.m_PythonPathUpdateType), (String)", ");
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"pythonPathEnvVar", (Object)(this.m_PythonPathEnvVar.length == 0 ? "-none-" : this.m_PythonPathEnvVar), (String)": ");
        }
        return result;
    }

    public String getActualPythonPath() {
        return this.m_ActualPythonPath;
    }

    public void updatePythonPath(Map<String, String> env) {
        if (this.m_ActualPythonPath != null) {
            env.put(PYTHONPATH, this.m_ActualPythonPath);
        }
    }

    public String getActualPython() {
        return this.m_ActualPython;
    }

    public String getActualPip() {
        return this.m_ActualPip;
    }

    protected String doExecute() {
        String result = null;
        String path = this.m_PythonPathEnvVar.length > 0 ? Utils.flatten((Object[])this.m_PythonPathEnvVar, (String)File.pathSeparator) : "";
        String currPath = System.getenv(PYTHONPATH);
        switch (this.m_PythonPathUpdateType) {
            case NO_UPDATE: {
                this.m_ActualPythonPath = null;
                break;
            }
            case REPLACE: {
                this.m_ActualPythonPath = path;
                break;
            }
            case APPEND: {
                if (currPath == null || currPath.isEmpty()) {
                    this.m_ActualPythonPath = path;
                    break;
                }
                this.m_ActualPythonPath = currPath + File.pathSeparator + path;
                break;
            }
            case PREPEND: {
                if (currPath == null || currPath.isEmpty()) {
                    this.m_ActualPythonPath = path;
                    break;
                }
                this.m_ActualPythonPath = path + File.pathSeparator + currPath;
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled python path update type: " + (Object)((Object)this.m_PythonPathUpdateType));
            }
        }
        if (this.m_Python.isDirectory()) {
            this.m_ActualPython = FileUtils.fixExecutable((String)("python" + this.m_Suffix));
        } else if (!this.m_Python.exists()) {
            result = "Python does not exist: " + this.m_Python;
        } else {
            this.m_ActualPython = FileUtils.fixExecutable((String)this.m_Python.getAbsolutePath());
        }
        if (result == null) {
            if (this.m_Pip.isDirectory()) {
                this.m_ActualPip = FileUtils.fixExecutable((String)("pip" + this.m_Suffix));
            } else if (!this.m_Pip.exists()) {
                result = "Pip does not exist: " + this.m_Pip;
            } else {
                this.m_ActualPip = FileUtils.fixExecutable((String)this.m_Pip.getAbsolutePath());
            }
        }
        if (result == null && this.isLoggingEnabled()) {
            this.getLogger().info("Python: " + this.m_ActualPython);
            this.getLogger().info("Pip: " + this.m_ActualPip);
        }
        return result;
    }

    public static enum PythonPathUpdateType {
        NO_UPDATE,
        REPLACE,
        APPEND,
        PREPEND;

    }
}

