/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Placeholders;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.BaseCharset;
import adams.core.io.EncodingSupporter;
import adams.core.io.FileUtils;
import adams.core.io.FileWriter;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;
import java.util.List;

public class PythonExpandScript
extends AbstractTransformer
implements FileWriter,
EncodingSupporter {
    private static final long serialVersionUID = -8993131926567885816L;
    protected BaseCharset m_Encoding;
    protected PlaceholderFile m_OutputFile;

    public String globalInfo() {
        return "Loads the Python script received as input, expands any variables and placeholders, saves it to the specified output file and forwards the output file name.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("encoding", "encoding", (Object)new BaseCharset());
        this.m_OptionManager.add("output", "outputFile", (Object)new PlaceholderFile("."));
    }

    public void setEncoding(BaseCharset value) {
        this.m_Encoding = value;
        this.reset();
    }

    public BaseCharset getEncoding() {
        return this.m_Encoding;
    }

    public String encodingTipText() {
        return "The type of encoding to use when reading/writing the script, use empty string for default.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"encoding", (Object)this.m_Encoding, (String)"enc: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"outputFile", (Object)this.m_OutputFile, (String)", out: ");
        return result;
    }

    public void setOutputFile(PlaceholderFile value) {
        this.m_OutputFile = value;
        this.reset();
    }

    public PlaceholderFile getOutputFile() {
        return this.m_OutputFile;
    }

    public String outputFileTipText() {
        return "The file to save the expanded script to.";
    }

    public Class[] accepts() {
        return new Class[]{String.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    protected String doExecute() {
        String result = null;
        PlaceholderFile script = new PlaceholderFile((String)this.m_InputToken.getPayload(String.class));
        if (!script.exists()) {
            result = "Script does not exist: " + script;
        } else if (script.isDirectory()) {
            result = "Script points to a directory: " + script;
        }
        List lines = null;
        if (result == null && (lines = FileUtils.loadFromFile((File)script, (String)this.m_Encoding.getValue())) == null) {
            result = "Failed to load script: " + script;
        }
        if (result == null) {
            for (int i = 0; i < lines.size(); ++i) {
                String line = (String)lines.get(i);
                line = this.getVariables().expand(line);
                line = Placeholders.getSingleton().expand(line);
                lines.set(i, line);
            }
            result = FileUtils.writeToFileMsg((String)this.m_OutputFile.getAbsolutePath(), (Object)Utils.flatten((List)lines, (String)"\n"), (boolean)false, (String)this.m_Encoding.getValue());
        }
        return result;
    }
}

