/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.Placeholders;
import adams.core.QuickInfoHelper;
import adams.core.base.BaseText;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.source.AbstractPythonExecution;
import java.util.ArrayList;
import java.util.Arrays;

public class PythonExec
extends AbstractPythonExecution {
    private static final long serialVersionUID = -132045002653940359L;
    protected PlaceholderFile m_Script;
    protected BaseText m_ScriptOptions;
    protected String m_WorkingDirectory;
    protected boolean m_OptionsContainPlaceholder;
    protected boolean m_OptionsContainVariable;

    public String globalInfo() {
        return "Executes the specified Python script with the specified options and broadcasts the generated output (stdout and/or stderr) continuously.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("script", "script", (Object)new PlaceholderFile());
        this.m_OptionManager.add("script-options", "scriptOptions", (Object)new BaseText(""));
        this.m_OptionManager.add("working-directory", "workingDirectory", (Object)"");
        this.m_OptionManager.add("placeholder", "optionsContainPlaceholder", (Object)false);
        this.m_OptionManager.add("variable", "optionsContainVariable", (Object)false);
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"script", (Object)this.m_Script);
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"scriptOptions", (Object)(this.m_ScriptOptions.isEmpty() ? "-none-" : this.m_ScriptOptions), (String)", options: ");
        if (value != null && !value.isEmpty()) {
            result = result + value;
        }
        return result;
    }

    public void setScript(PlaceholderFile value) {
        this.m_Script = value;
        this.reset();
    }

    public PlaceholderFile getScript() {
        return this.m_Script;
    }

    public String scriptTipText() {
        return "The Python command to run.";
    }

    public void setScriptOptions(BaseText value) {
        this.m_ScriptOptions = value;
        this.reset();
    }

    public BaseText getScriptOptions() {
        return this.m_ScriptOptions;
    }

    public String scriptOptionsTipText() {
        return "The command-line options for the script.";
    }

    public void setWorkingDirectory(String value) {
        this.m_WorkingDirectory = value;
        this.reset();
    }

    public String getWorkingDirectory() {
        return this.m_WorkingDirectory;
    }

    public String workingDirectoryTipText() {
        return "The current working directory for the command.";
    }

    public void setOptionsContainPlaceholder(boolean value) {
        this.m_OptionsContainPlaceholder = value;
        this.reset();
    }

    public boolean getOptionsContainPlaceholder() {
        return this.m_OptionsContainPlaceholder;
    }

    public String optionsContainPlaceholderTipText() {
        return "Set this to true to enable automatic placeholder expansion for the option string.";
    }

    public void setOptionsContainVariable(boolean value) {
        this.m_OptionsContainVariable = value;
        this.reset();
    }

    public boolean getOptionsContainVariable() {
        return this.m_OptionsContainVariable;
    }

    public String optionsContainVariableTipText() {
        return "Set this to true to enable automatic variable expansion for the option string.";
    }

    protected String doExecute() {
        String result = null;
        String options = "";
        if (this.m_ScriptOptions.length() > 0) {
            options = this.m_ScriptOptions.getValue();
            if (this.m_OptionsContainVariable) {
                options = this.getVariables().expand(options);
            }
            if (this.m_OptionsContainPlaceholder) {
                options = Placeholders.getSingleton().expand(options);
            }
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.m_Environment.getActualPython());
        cmd.add(this.m_Script.getAbsolutePath());
        if (this.m_ScriptOptions.length() > 0) {
            try {
                cmd.addAll(Arrays.asList(OptionUtils.splitOptions((String)options)));
            }
            catch (Exception e) {
                result = this.handleException("Failed to parse options: " + options, e);
            }
        }
        if (result == null) {
            result = this.launch(cmd, this.m_WorkingDirectory);
        }
        return result;
    }
}

