/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.Placeholders;
import adams.core.QuickInfoHelper;
import adams.core.base.BaseText;
import adams.core.io.FileUtils;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.source.AbstractPythonExecution;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;

public class PythonVenvExec
extends AbstractPythonExecution {
    private static final long serialVersionUID = -132045002653940359L;
    protected String m_Executable;
    protected BaseText m_ExecutableOptions;
    protected String m_WorkingDirectory;
    protected boolean m_OptionsContainPlaceholder;
    protected boolean m_OptionsContainVariable;

    public String globalInfo() {
        return "Executes the specified executable in a Python virtual environment with the specified options and broadcasts the generated output (stdout and/or stderr) continuously.\nFails if the specified environment does not contain any 'activate' scripts typically found in such directories.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("executable", "executable", (Object)"python");
        this.m_OptionManager.add("executable-options", "executableOptions", (Object)new BaseText(""));
        this.m_OptionManager.add("working-directory", "workingDirectory", (Object)"");
        this.m_OptionManager.add("placeholder", "optionsContainPlaceholder", (Object)false);
        this.m_OptionManager.add("variable", "optionsContainVariable", (Object)false);
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"executable", (Object)this.m_Executable);
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"executableOptions", (Object)(this.m_ExecutableOptions.isEmpty() ? "-none-" : this.m_ExecutableOptions), (String)", options: ");
        if (value != null && !value.isEmpty()) {
            result = result + value;
        }
        return result;
    }

    public void setExecutable(String value) {
        this.m_Executable = value;
        this.reset();
    }

    public String getExecutable() {
        return this.m_Executable;
    }

    public String executableTipText() {
        return "The executable from the virtual environment to run (no path).";
    }

    public void setExecutableOptions(BaseText value) {
        this.m_ExecutableOptions = value;
        this.reset();
    }

    public BaseText getExecutableOptions() {
        return this.m_ExecutableOptions;
    }

    public String executableOptionsTipText() {
        return "The command-line options for the executable.";
    }

    public void setWorkingDirectory(String value) {
        this.m_WorkingDirectory = value;
        this.reset();
    }

    public String getWorkingDirectory() {
        return this.m_WorkingDirectory;
    }

    public String workingDirectoryTipText() {
        return "The current working directory for the command.";
    }

    public void setOptionsContainPlaceholder(boolean value) {
        this.m_OptionsContainPlaceholder = value;
        this.reset();
    }

    public boolean getOptionsContainPlaceholder() {
        return this.m_OptionsContainPlaceholder;
    }

    public String optionsContainPlaceholderTipText() {
        return "Set this to true to enable automatic placeholder expansion for the option string.";
    }

    public void setOptionsContainVariable(boolean value) {
        this.m_OptionsContainVariable = value;
        this.reset();
    }

    public boolean getOptionsContainVariable() {
        return this.m_OptionsContainVariable;
    }

    public String optionsContainVariableTipText() {
        return "Set this to true to enable automatic variable expansion for the option string.";
    }

    protected String doExecute() {
        String result = null;
        String envDir = this.m_Environment.getActualBinDir();
        if (!(FileUtils.fileExists((String)(envDir + File.separator + "activate")) || FileUtils.fileExists((String)(envDir + File.separator + "activate.csh")) || FileUtils.fileExists((String)(envDir + File.separator + "activate.bat")))) {
            result = "This doesn't look like a typical virtual environment (no 'activate' scripts): " + envDir;
        }
        String options = "";
        if (this.m_ExecutableOptions.length() > 0) {
            options = this.m_ExecutableOptions.getValue();
            if (this.m_OptionsContainVariable) {
                options = this.getVariables().expand(options);
            }
            if (this.m_OptionsContainPlaceholder) {
                options = Placeholders.getSingleton().expand(options);
            }
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(envDir + File.separator + FileUtils.fixExecutable((String)this.m_Executable));
        if (this.m_ExecutableOptions.length() > 0) {
            try {
                cmd.addAll(Arrays.asList(OptionUtils.splitOptions((String)options)));
            }
            catch (Exception e) {
                result = this.handleException("Failed to parse options: " + options, e);
            }
        }
        if (result == null) {
            result = this.launch(cmd, this.m_WorkingDirectory);
        }
        return result;
    }
}

