/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.pyrotransformer.AbstractPyroTransformer;
import adams.flow.transformer.pyrotransformer.Null;

public class PyroTransformer
extends AbstractTransformer {
    private static final long serialVersionUID = -1719389733948167820L;
    protected AbstractPyroTransformer m_Call;

    public String globalInfo() {
        return "Transforms data using a Pyro4 call\n\nFor more information see:\nhttps://pythonhosted.org/Pyro4/\nhttps://github.com/irmen/Pyrolite";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("call", "call", (Object)new Null());
    }

    public void setCall(AbstractPyroTransformer value) {
        this.m_Call = value;
        this.reset();
    }

    public AbstractPyroTransformer getCall() {
        return this.m_Call;
    }

    public String callTipText() {
        return "The Pyro call to use for transforming the data.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"call", (Object)this.m_Call);
    }

    public Class[] accepts() {
        return this.m_Call.accepts();
    }

    public Class[] generates() {
        return this.m_Call.generates();
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Call.setFlowContext((Actor)this);
            result = this.m_Call.setUp();
        }
        return result;
    }

    protected String doExecute() {
        this.m_Call.input(this.m_InputToken.getPayload());
        String result = this.m_Call.execute();
        if (result == null && this.m_Call.hasPendingOutput()) {
            this.m_OutputToken = new Token(this.m_Call.output());
        }
        this.m_Call.cleanUp();
        return result;
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_Call.cleanUp();
    }
}

