/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.QuickInfoHelper;
import adams.core.QuickInfoSupporter;
import adams.core.Utils;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.PyroCall;
import adams.flow.standalone.PyroNameServer;
import net.razorvine.pyro.PyroProxy;

public abstract class AbstractPyroCall
extends AbstractOptionHandler
implements PyroCall,
QuickInfoSupporter {
    private static final long serialVersionUID = -5360445580341176447L;
    protected String m_RemoteObjectName;
    protected String m_MethodName;
    protected transient Actor m_FlowContext;
    protected transient PyroNameServer m_NameServer;
    protected transient PyroProxy m_RemoteObject;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("remote-object-name", "remoteObjectName", (Object)this.getDefaultRemoteObjectName());
        this.m_OptionManager.add("method-name", "methodName", (Object)this.getDefaultMethodName());
    }

    protected void reset() {
        super.reset();
        this.m_NameServer = null;
        this.m_RemoteObject = null;
    }

    protected String getDefaultRemoteObjectName() {
        return "";
    }

    @Override
    public void setRemoteObjectName(String value) {
        this.m_RemoteObjectName = value;
        this.reset();
    }

    @Override
    public String getRemoteObjectName() {
        return this.m_RemoteObjectName;
    }

    @Override
    public String remoteObjectNameTipText() {
        return "The name of the remote object to use.";
    }

    protected String getDefaultMethodName() {
        return "";
    }

    @Override
    public void setMethodName(String value) {
        this.m_MethodName = value;
        this.reset();
    }

    @Override
    public String getMethodName() {
        return this.m_MethodName;
    }

    @Override
    public String methodNameTipText() {
        return "The name of the method to call.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"remoteObjectName", (Object)this.m_RemoteObjectName, (String)"remote object: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"methodName", (Object)this.m_MethodName, (String)", method: ");
        return result;
    }

    public void setFlowContext(Actor value) {
        this.m_FlowContext = value;
    }

    public Actor getFlowContext() {
        return this.m_FlowContext;
    }

    @Override
    public String setUp() {
        if (this.m_FlowContext == null) {
            return "No flow context set!";
        }
        if (this.m_RemoteObjectName.trim().isEmpty()) {
            return "No remote object name provided!";
        }
        if (this.m_MethodName.trim().isEmpty()) {
            return "No method name provided!";
        }
        this.m_NameServer = (PyroNameServer)ActorUtils.findClosestType((Actor)this.m_FlowContext, PyroNameServer.class, (boolean)true);
        if (this.m_NameServer == null) {
            return "Failed to locate a " + Utils.classToString(PyroNameServer.class) + " actor!";
        }
        return null;
    }

    protected String preExecute() {
        String result = null;
        if (this.m_NameServer.getNameServer() == null) {
            return "No name server instance available!";
        }
        if (this.m_RemoteObject == null) {
            try {
                this.m_RemoteObject = new PyroProxy(this.m_NameServer.getNameServer().lookup(this.m_RemoteObjectName));
            }
            catch (Exception e) {
                result = LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to obtain remote object: " + this.m_RemoteObjectName), (Throwable)e);
            }
        }
        return result;
    }

    protected abstract String doExecute();

    protected String postExecute() {
        return null;
    }

    @Override
    public String execute() {
        String result = this.preExecute();
        if (result == null) {
            result = this.doExecute();
        }
        if (result == null) {
            result = this.postExecute();
        }
        return result;
    }

    public void cleanUp() {
        this.m_NameServer = null;
        this.m_FlowContext = null;
    }
}

