/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.StoppableWithFeedback;
import adams.core.Utils;
import adams.core.io.PlaceholderDirectory;
import adams.core.logging.LoggingSupporter;
import adams.core.option.OptionUtils;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.RunnableWithLogging;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;
import adams.flow.standalone.PythonEnvironment;
import com.github.fracpete.processoutput4j.core.StreamingProcessOutputType;
import com.github.fracpete.processoutput4j.core.StreamingProcessOwner;
import com.github.fracpete.processoutput4j.output.StreamingProcessOutput;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractPythonExecution
extends AbstractSource
implements StreamingProcessOwner {
    private static final long serialVersionUID = -132045002653940359L;
    protected StreamingProcessOutputType m_OutputType;
    protected String m_PrefixStdOut;
    protected String m_PrefixStdErr;
    protected List m_Output;
    protected transient StreamingProcessOutput m_ProcessOutput;
    protected RunnableWithLogging m_Monitor;
    protected IllegalStateException m_ExecutionFailure;
    protected int m_TimeOut;
    protected PythonEnvironment m_Environment;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-type", "outputType", (Object)StreamingProcessOutputType.STDOUT);
        this.m_OptionManager.add("prefix-stdout", "prefixStdOut", (Object)"");
        this.m_OptionManager.add("prefix-stderr", "prefixStdErr", (Object)"");
        this.m_OptionManager.add("time-out", "timeOut", (Object)-1, (Number)-1, null);
    }

    protected void initialize() {
        super.initialize();
        this.m_Output = new ArrayList();
    }

    protected void reset() {
        super.reset();
        this.m_Output.clear();
    }

    public void setOutputType(StreamingProcessOutputType value) {
        this.m_OutputType = value;
        this.reset();
    }

    public StreamingProcessOutputType getOutputType() {
        return this.m_OutputType;
    }

    public String outputTypeTipText() {
        return "Determines the output type; if " + StreamingProcessOutputType.BOTH + " is selected then an array is output with stdout as first element and stderr as second";
    }

    public void setPrefixStdOut(String value) {
        this.m_PrefixStdOut = value;
        this.reset();
    }

    public String getPrefixStdOut() {
        return this.m_PrefixStdOut;
    }

    public String prefixStdOutTipText() {
        return "The (optional) prefix to use for output from stdout.";
    }

    public void setPrefixStdErr(String value) {
        this.m_PrefixStdErr = value;
        this.reset();
    }

    public String getPrefixStdErr() {
        return this.m_PrefixStdErr;
    }

    public String prefixStdErrTipText() {
        return "The (optional) prefix to use for output from stderr.";
    }

    public void setTimeOut(int value) {
        if (this.getOptionManager().isValid("timeOut", (Number)value)) {
            this.m_TimeOut = value;
            this.reset();
        }
    }

    public int getTimeOut() {
        return this.m_TimeOut;
    }

    public String timeOutTipText() {
        return "The maximum time in seconds for the process to run before getting killed, ignored if less than 1.";
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Environment = (PythonEnvironment)ActorUtils.findClosestType((Actor)this, PythonEnvironment.class, (boolean)true);
            if (this.m_Environment == null) {
                result = "Failed to locate a " + Utils.classToString(PythonEnvironment.class) + " actor!";
            }
        }
        return result;
    }

    protected String launch(final List<String> cmd, final String workingDir) {
        String result = null;
        this.m_Output.clear();
        if (result == null) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Command: " + OptionUtils.joinOptions((String[])cmd.toArray(new String[cmd.size()])));
                if (!workingDir.isEmpty()) {
                    this.getLogger().info("Working dir: " + workingDir);
                }
            }
            this.m_ExecutionFailure = null;
            this.m_ProcessOutput = new StreamingProcessOutput((StreamingProcessOwner)this);
            this.m_ProcessOutput.setTimeOut(this.m_TimeOut);
            this.m_Monitor = new RunnableWithLogging(){
                private static final long serialVersionUID = -4475355379511760429L;

                protected void doRun() {
                    try {
                        ProcessBuilder builder = new ProcessBuilder(cmd);
                        if (!workingDir.isEmpty()) {
                            builder.directory(new PlaceholderDirectory(workingDir).getAbsoluteFile());
                        }
                        AbstractPythonExecution.this.m_Environment.updatePythonPath(builder.environment());
                        AbstractPythonExecution.this.m_ProcessOutput.monitor(builder);
                    }
                    catch (Exception e) {
                        AbstractPythonExecution.this.m_ExecutionFailure = new IllegalStateException("Failed to execute: " + OptionUtils.joinOptions((String[])cmd.toArray(new String[cmd.size()])), e);
                    }
                    AbstractPythonExecution.this.m_Monitor = null;
                    AbstractPythonExecution.this.m_ProcessOutput = null;
                }

                public void stopExecution() {
                    if (AbstractPythonExecution.this.m_ProcessOutput != null) {
                        AbstractPythonExecution.this.m_ProcessOutput.destroy();
                    }
                    super.stopExecution();
                }
            };
            new Thread((Runnable)this.m_Monitor).start();
        }
        return result;
    }

    public void processOutput(String line, boolean stdout) {
        line = stdout ? this.m_PrefixStdOut + line : this.m_PrefixStdErr + line;
        this.m_Output.add(line);
        if (this.isLoggingEnabled()) {
            this.getLogger().info(line);
        }
    }

    public Token output() {
        Token result = null;
        while (this.m_Output.size() == 0 && !this.isStopped() && this.m_Monitor != null) {
            Utils.wait((LoggingSupporter)this, (StoppableWithFeedback)this, (int)1000, (int)100);
        }
        if (this.m_ExecutionFailure != null) {
            IllegalStateException exc = this.m_ExecutionFailure;
            this.m_ExecutionFailure = null;
            throw exc;
        }
        if (!this.isStopped() && this.m_Output.size() > 0) {
            result = new Token(this.m_Output.get(0));
            this.m_Output.remove(0);
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_Output.size() > 0 || this.m_Monitor != null;
    }

    public void stopExecution() {
        if (this.m_Monitor != null) {
            this.m_Monitor.stopExecution();
        }
        super.stopExecution();
    }
}

