/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.Placeholders;
import adams.core.QuickInfoHelper;
import adams.core.base.BaseText;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.source.AbstractPythonExecution;
import java.util.ArrayList;
import java.util.Arrays;

public class PipExec
extends AbstractPythonExecution {
    private static final long serialVersionUID = -132045002653940359L;
    protected BaseText m_Options;
    protected boolean m_OptionsContainPlaceholder;
    protected boolean m_OptionsContainVariable;

    public String globalInfo() {
        return "Executes pip with the specified options and broadcasts the generated output (stdout and/or stderr) continuously.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("options", "options", (Object)new BaseText(""));
        this.m_OptionManager.add("placeholder", "optionsContainPlaceholder", (Object)false);
        this.m_OptionManager.add("variable", "optionsContainVariable", (Object)false);
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"scriptOptions", (Object)(this.m_Options.isEmpty() ? "-none-" : this.m_Options), (String)"options: ");
    }

    public void setOptions(BaseText value) {
        this.m_Options = value;
        this.reset();
    }

    public BaseText getOptions() {
        return this.m_Options;
    }

    public String optionsTipText() {
        return "The options for pip.";
    }

    public void setOptionsContainPlaceholder(boolean value) {
        this.m_OptionsContainPlaceholder = value;
        this.reset();
    }

    public boolean getOptionsContainPlaceholder() {
        return this.m_OptionsContainPlaceholder;
    }

    public String optionsContainPlaceholderTipText() {
        return "Set this to true to enable automatic placeholder expansion for the option string.";
    }

    public void setOptionsContainVariable(boolean value) {
        this.m_OptionsContainVariable = value;
        this.reset();
    }

    public boolean getOptionsContainVariable() {
        return this.m_OptionsContainVariable;
    }

    public String optionsContainVariableTipText() {
        return "Set this to true to enable automatic variable expansion for the option string.";
    }

    protected String doExecute() {
        String result = null;
        String options = "";
        if (this.m_Options.length() > 0) {
            options = this.m_Options.getValue();
            if (this.m_OptionsContainVariable) {
                options = this.getVariables().expand(options);
            }
            if (this.m_OptionsContainPlaceholder) {
                options = Placeholders.getSingleton().expand(options);
            }
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.m_Environment.getActualPip());
        if (this.m_Options.length() > 0) {
            try {
                cmd.addAll(Arrays.asList(OptionUtils.splitOptions((String)options)));
            }
            catch (Exception e) {
                result = this.handleException("Failed to parse options: " + options, e);
            }
        }
        if (result == null) {
            result = this.launch(cmd, "");
        }
        return result;
    }
}

