/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * RSource.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.source;

import adams.data.statistics.StatUtils;
import adams.flow.core.Token;
import adams.flow.standalone.RServe;

public class RSource
  extends AbstractSource {

  /** for serialization */
  private static final long serialVersionUID = -3064162887434390818L;

  /** Script to pass to r*/
  protected String m_rScript;

  /**Data type of object returned from r script*/
  protected DataType m_returnType;

  /**Object returned from r*/
  protected Object m_returnedObject;

  public void defineOptions() {
    super.defineOptions();

    m_OptionManager.add(
	"r-Script", "rScript",
        "");

    m_OptionManager.add(
	"return-type", "returnType",
	DataType.Integer);
  }

  public void setReturnType(DataType val) {
    m_returnType = val;
    reset();
  }

  public DataType getReturnType() {
    return m_returnType;
  }

  public String returnTypeTipText() {
    return "Data type of returned object";
  }


  public void setRScript(String val) {
    m_rScript = val;
    reset();
  }

  public String getRScript() {
    return m_rScript;
  }

  public String rScriptTipText() {
    return "Script to pass into r";
  }

  public enum DataType {
    Integer, IntArray, Int2DArray, Double, DubArray, Dub2DArray, String, StrArray, Str2DArray
  }

  public Class[] generates() {
    Class[]	generated = new Class[]{};

    switch (m_returnType) {
      case Integer:
	generated = new Class[]{Integer.class};
	break;

      case IntArray:
	generated = new Class[]{Integer[].class};
	break;

      case Int2DArray:
	generated = new Class[]{Integer[][].class};
	break;

      case String:
	generated = new Class[]{String.class};
	break;

      case StrArray:
	generated = new Class[]{String[].class};
	break;

      case Str2DArray:
	generated = new Class[]{Integer[][].class};
	break;

      case Double:
	generated = new Class[]{Double.class};
	break;

      case DubArray:
	generated = new Class[]{Double[].class};
	break;

      default:
	generated = new Class[]{Double[][].class};
	break;
    }
    return generated;
  }

  public Token output() {
    Token result = new Token(m_returnedObject);
    m_returnedObject = null;
    return result;
  }

  public boolean hasPendingOutput() {
    return (m_returnedObject != null);
  }

  protected String doExecute() {
    RServe rs = new RServe();
    double[] dbl = (double[]) rs.doRequest(m_rScript);
    m_returnedObject = StatUtils.toNumberArray(dbl);
    return null;
  }

  @Override
  public String globalInfo() {
    return "Carries out an R function on the input script";
  }

}

