/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.Placeholders;
import adams.core.RDataHelper;
import adams.core.Utils;
import adams.core.scripting.RScript;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.statistics.StatUtils;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.sink.AbstractSink;
import adams.flow.standalone.Rserve;
import org.rosuda.REngine.Rserve.RConnection;

public class RSink
extends AbstractSink {
    private static final long serialVersionUID = 6150602242914328836L;
    public static final String INPUT = "X";
    protected RScript m_Script;
    protected RConnection m_RConn;
    protected Rserve m_Rserve;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("script", "script", (Object)new RScript());
    }

    protected void reset() {
        super.reset();
        this.m_RConn = null;
    }

    public void setScript(RScript val) {
        this.m_Script = val;
        this.reset();
    }

    public RScript getScript() {
        return this.m_Script;
    }

    public String scriptTipText() {
        return "Script to pass into r. The input value can be accessed via 'X'.";
    }

    public String getQuickInfo() {
        String result = "script: ";
        String variable = this.getOptionManager().getVariableForProperty("script");
        result = variable != null ? result + variable : result + Utils.shorten((String)this.m_Script.stringValue(), (int)40);
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Integer.class, String.class, Double.class, Double[].class, Double[][].class, SpreadSheet.class};
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Rserve = (Rserve)ActorUtils.findClosestType((AbstractActor)this, Rserve.class, (boolean)true);
            if (this.m_Rserve == null) {
                result = "Failed to find " + Rserve.class.getName() + " standalone with Rserve configuration!";
            }
        }
        return result;
    }

    protected String doExecute() {
        if (this.m_RConn == null) {
            this.m_RConn = this.m_Rserve.newConnection();
            if (this.m_RConn == null) {
                return "Could not connect to Rserve!";
            }
        }
        String expr = this.getVariables().expand(this.m_Script.getValue());
        expr = Placeholders.expandStr((String)expr);
        try {
            String[] lines;
            if (this.m_InputToken.getPayload() instanceof Integer) {
                this.m_RConn.assign(INPUT, new int[]{(Integer)this.m_InputToken.getPayload()});
            } else if (this.m_InputToken.getPayload() instanceof String) {
                this.m_RConn.assign(INPUT, (String)this.m_InputToken.getPayload());
            } else if (this.m_InputToken.getPayload() instanceof Double) {
                this.m_RConn.assign(INPUT, new double[]{(Double)this.m_InputToken.getPayload()});
            } else if (this.m_InputToken.getPayload() instanceof Double[]) {
                this.m_RConn.assign(INPUT, StatUtils.toDoubleArray((Number[])((Double[])this.m_InputToken.getPayload())));
            } else if (this.m_InputToken.getPayload() instanceof Double[][]) {
                int i;
                Double[][] temp = (Double[][])this.m_InputToken.getPayload();
                double[][] dubMat = new double[temp.length][];
                for (i = 0; i < temp.length; ++i) {
                    dubMat[i] = StatUtils.toDoubleArray((Number[])temp[i]);
                }
                this.m_RConn.assign(INPUT, dubMat[0]);
                for (i = 1; i < dubMat.length; ++i) {
                    this.m_RConn.assign("tmp", dubMat[i]);
                    this.m_RConn.eval("X<-rbind(X,tmp)");
                }
            } else if (this.m_InputToken.getPayload() instanceof SpreadSheet) {
                this.m_RConn.assign(INPUT, RDataHelper.spreadsheetToDataframe((SpreadSheet)this.m_InputToken.getPayload()));
            } else {
                throw new IllegalStateException("Unhandled class: " + this.m_InputToken.getPayload().getClass());
            }
            for (String line : lines = expr.split("\r?\n")) {
                try {
                    this.m_RConn.eval(line);
                }
                catch (Exception ex) {
                    return this.handleException("Error occurred evaluating: " + line, ex);
                }
            }
        }
        catch (Exception e) {
            return this.handleException("Error occurred calling Rserve:", e);
        }
        return null;
    }

    public String globalInfo() {
        return "Carries out an r command on the token passed in. The input can be accessed via 'X'.\nVariables are supported as well, e.g.: pow(X,@{exp}) with '@{exp}' being a variable available at execution time.";
    }

    public void wrapUp() {
        if (this.m_Rserve != null) {
            this.m_Rserve.closeConnection(this.m_RConn);
            this.m_RConn = null;
            this.m_Rserve = null;
        }
        super.wrapUp();
    }
}

