/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.RObjectPath;
import adams.core.io.FileUtils;
import adams.core.logging.Logger;
import adams.core.logging.LoggingHelper;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.renjin.serialization.RDataReader;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;

public class RObjectInspector {
    protected static Logger LOGGER;

    protected static synchronized Logger getLogger() {
        if (LOGGER == null) {
            LOGGER = LoggingHelper.getLogger(RObjectInspector.class);
        }
        return LOGGER;
    }

    protected static List<RObjectPath> list(RObjectPath parent, SEXP robj) {
        ArrayList<RObjectPath> result = new ArrayList<RObjectPath>();
        if (robj instanceof PairList) {
            try {
                PairList pairlist = (PairList)robj;
                for (PairList.Node node : pairlist.nodes()) {
                    if (parent == null) {
                        result.add(new RObjectPath(new String[]{node.getName()}));
                    } else {
                        result.add(parent.addChild(node.getName()));
                    }
                    if (!(node.getValue() instanceof PairList)) continue;
                    result.addAll(RObjectInspector.list((RObjectPath)result.get(result.size() - 1), node.getValue()));
                }
            }
            catch (Exception e) {
                RObjectInspector.getLogger().log(Level.SEVERE, "Failed to list object paths!", (Throwable)e);
            }
        }
        return result;
    }

    public static List<RObjectPath> list(SEXP robj) {
        return RObjectInspector.list(null, robj);
    }

    public static SEXP get(SEXP robj, RObjectPath path) {
        SEXP result = null;
        SEXP current = robj;
        int i = 0;
        block0: while (i < path.getPathCount()) {
            if (current instanceof PairList) {
                PairList pairlist = (PairList)current;
                for (PairList.Node node : pairlist.nodes()) {
                    if (!node.getName().equals(path.getPathComponent(i))) continue;
                    current = node.getValue();
                    if (i == path.getPathCount() - 1) {
                        result = current;
                    }
                    ++i;
                    continue block0;
                }
                continue;
            }
            RObjectInspector.getLogger().warning("Failed to locate R object: " + path);
            return null;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("Renjin");
        if (engine == null) {
            throw new RuntimeException("Some error msg");
        }
        FileInputStream in = new FileInputStream("/home/fracpete/temp/spectral/rdata/Data.WHEAT1.Rdata");
        GZIPInputStream zin = new GZIPInputStream(in);
        RDataReader reader = new RDataReader((InputStream)zin);
        SEXP robj = reader.readFile();
        List<RObjectPath> paths = RObjectInspector.list(robj);
        for (RObjectPath path : paths) {
            System.out.println("\n--> " + path);
            System.out.println(RObjectInspector.get(robj, path));
        }
        reader.close();
        FileUtils.closeQuietly((InputStream)zin);
        FileUtils.closeQuietly((InputStream)in);
    }
}

