/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public class RObjectPath
implements Comparable<RObjectPath>,
Serializable {
    private static final long serialVersionUID = -5734626103557090578L;
    protected String[] m_Parts;
    protected String m_FullPath;

    public RObjectPath() {
        this("");
    }

    public RObjectPath(String path) {
        this.m_FullPath = null;
        if (path == null || path.length() == 0) {
            this.m_Parts = new String[0];
        } else {
            path = path.replace("\\.", "\t");
            path = path.replaceAll("\\s*$", "");
            this.m_Parts = path.split("\\.");
            for (int i = 0; i < this.m_Parts.length; ++i) {
                this.m_Parts[i] = this.m_Parts[i].replace("\t", ".");
            }
        }
    }

    public RObjectPath(String[] path) {
        this.m_Parts = (String[])path.clone();
        this.m_FullPath = null;
    }

    public boolean isEmpty() {
        return this.m_Parts.length == 0;
    }

    public String[] getPath() {
        return (String[])this.m_Parts.clone();
    }

    public int getPathCount() {
        return this.m_Parts.length;
    }

    public String getPathComponent(int element) {
        return this.m_Parts[element];
    }

    public RObjectPath getParentPath() {
        String[] parts;
        if (this.m_Parts.length >= 1) {
            parts = new String[this.m_Parts.length - 1];
            for (int i = 0; i < parts.length; ++i) {
                parts[i] = new String(this.m_Parts[i]);
            }
        } else {
            parts = new String[]{};
        }
        return new RObjectPath(parts);
    }

    public RObjectPath getChildPath() {
        String[] parts;
        if (this.m_Parts.length >= 1) {
            parts = new String[this.m_Parts.length - 1];
            for (int i = 1; i < this.m_Parts.length; ++i) {
                parts[i - 1] = this.m_Parts[i];
            }
        } else {
            parts = new String[]{};
        }
        return new RObjectPath(parts);
    }

    public String getLastPathComponent() {
        if (this.m_Parts.length > 0) {
            return this.m_Parts[this.m_Parts.length - 1];
        }
        return null;
    }

    public String getFirstPathComponent() {
        if (this.m_Parts.length > 0) {
            return this.m_Parts[0];
        }
        return null;
    }

    public boolean isDescendant(RObjectPath objectPath) {
        boolean result;
        boolean bl = result = objectPath.getPathCount() >= this.getPathCount();
        if (result) {
            for (int i = 0; i < this.getPathCount(); ++i) {
                if (this.getPathComponent(i).equals(objectPath.getPathComponent(i))) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public RObjectPath getCommonAncestor(RObjectPath objectPath) {
        ArrayList<String> parts = new ArrayList<String>();
        for (int i = 0; i < this.getPathCount() && i < objectPath.getPathCount() && this.getPathComponent(i).equals(objectPath.getPathComponent(i)); ++i) {
            parts.add(this.getPathComponent(i));
        }
        return new RObjectPath(parts.toArray(new String[0]));
    }

    public RObjectPath addChild(String path) {
        String[] elements = new String[this.m_Parts.length + 1];
        for (int i = 0; i < this.m_Parts.length; ++i) {
            elements[i] = this.m_Parts[i];
        }
        elements[elements.length - 1] = path;
        return new RObjectPath(elements);
    }

    @Override
    public int compareTo(RObjectPath o) {
        if (this.getPathCount() == 0 || o.getPathCount() == 0) {
            return Integer.compare(this.getPathCount(), o.getPathCount());
        }
        int result = 0;
        for (int i = 0; i < this.getPathCount() && i < o.getPathCount(); ++i) {
            result = this.getPathComponent(i).compareTo(o.getPathComponent(i));
            if (result == 0 && (i == this.getPathCount() - 1 || i == o.getPathCount() - 1)) {
                result = Integer.compare(this.getPathCount(), o.getPathCount());
            }
            if (result != 0) break;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof RObjectPath) {
            return this.compareTo((RObjectPath)o) == 0;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.m_Parts);
    }

    public String toString() {
        if (this.m_FullPath == null) {
            StringBuilder path = new StringBuilder();
            for (String part : this.m_Parts) {
                if (path.length() > 0) {
                    path.append(".");
                }
                path.append(part.replace(".", "\\."));
            }
            this.m_FullPath = path.toString();
        }
        return this.m_FullPath;
    }
}

