/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.Properties;
import adams.env.Environment;
import java.io.File;

public class RProjectHelper {
    public static final String FILENAME = "RProject.props";
    public static final String R_EXECUTABLE = "RExecutable";
    public static final String RSERVE_HOST = "RserveHost";
    public static final String RSERVE_PORT = "RservePort";
    protected static RProjectHelper m_Singleton;
    protected Properties m_Properties;
    protected boolean m_Modified;

    private RProjectHelper() {
        this.reload();
    }

    public boolean isModified() {
        return this.m_Modified;
    }

    public File getRExecutable() {
        return new File(this.m_Properties.getPath(R_EXECUTABLE, "R"));
    }

    public void setRExecutable(File value) {
        this.m_Modified = true;
        this.m_Properties.setProperty(R_EXECUTABLE, value.getAbsolutePath());
    }

    public String getRserveHost() {
        return this.m_Properties.getPath(RSERVE_HOST, "localhost");
    }

    public void setRserveHost(String value) {
        this.m_Modified = true;
        this.m_Properties.setProperty(RSERVE_HOST, value);
    }

    public int getRservePort() {
        return this.m_Properties.getInteger(RSERVE_PORT, Integer.valueOf(6311));
    }

    public void setRservePort(int value) {
        this.m_Modified = true;
        this.m_Properties.setInteger(RSERVE_PORT, Integer.valueOf(value));
    }

    public synchronized void reload() {
        this.m_Modified = false;
        try {
            this.m_Properties = Environment.getInstance().read("r-project");
        }
        catch (Exception e) {
            this.m_Properties = new Properties();
        }
    }

    public synchronized boolean save() {
        boolean result = Environment.getInstance().write("r-project", this.m_Properties);
        if (result) {
            this.m_Modified = false;
        }
        return result;
    }

    public static synchronized RProjectHelper getSingleton() {
        if (m_Singleton == null) {
            m_Singleton = new RProjectHelper();
        }
        return m_Singleton;
    }
}

