/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.LenientModeSupporter;
import adams.core.RObjectHelper;
import adams.core.Utils;
import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.SEXP;

public class RenjinDoubleArrayVectorToSpreadSheet
extends AbstractConversion
implements LenientModeSupporter {
    private static final long serialVersionUID = 9071543768077107751L;
    protected boolean m_Lenient;

    public String globalInfo() {
        return "Turns a Renjin double array vector matrix into a spreadsheet.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("lenient", "lenient", (Object)true);
    }

    public void setLenient(boolean value) {
        this.m_Lenient = value;
        this.reset();
    }

    public boolean getLenient() {
        return this.m_Lenient;
    }

    public String lenientTipText() {
        return "If enabled, the types will be more lenient.";
    }

    public Class accepts() {
        if (this.m_Lenient) {
            return SEXP.class;
        }
        return DoubleArrayVector.class;
    }

    public Class generates() {
        return SpreadSheet.class;
    }

    protected Object doConvert() throws Exception {
        int i;
        String[] rowNames;
        String[] colNames;
        int rows;
        int cols;
        DoubleArrayVector input = (DoubleArrayVector)this.m_Input;
        int[] dims = RObjectHelper.getDimensions((SEXP)input);
        if (dims.length == 1) {
            cols = dims[0];
            rows = 1;
            colNames = RObjectHelper.getDimensionNames((SEXP)input, 0);
            rowNames = null;
        } else if (dims.length == 2) {
            rows = dims[0];
            cols = dims[1];
            rowNames = RObjectHelper.getDimensionNames((SEXP)input, 0);
            colNames = RObjectHelper.getDimensionNames((SEXP)input, 1);
        } else {
            throw new IllegalStateException("Expected 1 or 2 dimensions, but got: " + Utils.arrayToString((Object)dims));
        }
        DefaultSpreadSheet result = new DefaultSpreadSheet();
        HeaderRow row = result.getHeaderRow();
        if (rowNames != null) {
            row.addCell("rid").setContentAsString("Row-ID");
        }
        for (i = 0; i < cols; ++i) {
            if (colNames == null) {
                row.addCell("" + i).setContentAsString("Col-" + (i + 1));
                continue;
            }
            row.addCell("" + i).setContentAsString(colNames[i]);
        }
        for (i = 0; i < rows; ++i) {
            result.addRow();
        }
        for (i = 0; i < input.length(); ++i) {
            int y = i % rows;
            int x = i / rows;
            if (rowNames != null) {
                result.getCell(y, 0).setContentAsString(rowNames[y]);
                ++x;
            }
            result.getCell(y, x).setContent(Double.valueOf(input.getElementAsDouble(i)));
        }
        return result;
    }
}

