/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.LenientModeSupporter;
import adams.data.conversion.AbstractConversion;
import java.lang.reflect.Array;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.SEXP;

public class RenjinListVectorToArray
extends AbstractConversion
implements LenientModeSupporter {
    private static final long serialVersionUID = 2094304665550675734L;
    protected boolean m_Lenient;

    public String globalInfo() {
        return "Converts an Renjin list into an array.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("lenient", "lenient", (Object)true);
    }

    public void setLenient(boolean value) {
        this.m_Lenient = value;
        this.reset();
    }

    public boolean getLenient() {
        return this.m_Lenient;
    }

    public String lenientTipText() {
        return "If enabled, the types will be more lenient.";
    }

    public Class accepts() {
        if (this.m_Lenient) {
            return SEXP.class;
        }
        return ListVector.class;
    }

    public Class generates() {
        return SEXP[].class;
    }

    protected Object doConvert() throws Exception {
        ListVector input = (ListVector)this.m_Input;
        Object result = Array.newInstance(Object.class, input.length());
        for (int i = 0; i < input.length(); ++i) {
            Array.set(result, i, input.get(i));
        }
        return result;
    }
}

