/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.Placeholders;
import adams.core.QuickInfoHelper;
import adams.core.RDataHelper;
import adams.core.Shortening;
import adams.core.Utils;
import adams.core.base.BaseCharset;
import adams.core.io.EncodingSupporter;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.core.scripting.RScript;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.statistics.StatUtils;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.sink.AbstractSink;
import adams.flow.standalone.Rserve;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.rosuda.REngine.Rserve.RConnection;

public class RSink
extends AbstractSink
implements EncodingSupporter {
    private static final long serialVersionUID = 6150602242914328836L;
    public static final String INPUT = "X";
    protected PlaceholderFile m_ScriptFile;
    protected BaseCharset m_Encoding;
    protected RScript m_InlineScript;
    protected boolean m_ScriptContainsPlaceholder;
    protected boolean m_ScriptContainsVariable;
    protected boolean m_LineByLine;
    protected RConnection m_RConn;
    protected Rserve m_Rserve;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("script-file", "scriptFile", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("encoding", "encoding", (Object)new BaseCharset());
        this.m_OptionManager.add("script", "inlineScript", (Object)new RScript());
        this.m_OptionManager.add("placeholder", "scriptContainsPlaceholder", (Object)false);
        this.m_OptionManager.add("variable", "scriptContainsVariable", (Object)false);
        this.m_OptionManager.add("line-by-line", "lineByLine", (Object)true);
    }

    public void setScriptFile(PlaceholderFile value) {
        this.m_ScriptFile = value;
        this.reset();
    }

    public PlaceholderFile getScriptFile() {
        return this.m_ScriptFile;
    }

    public String scriptFileTipText() {
        return "The script file to load and execute.";
    }

    public void setEncoding(BaseCharset value) {
        this.m_Encoding = value;
        this.reset();
    }

    public BaseCharset getEncoding() {
        return this.m_Encoding;
    }

    public String encodingTipText() {
        return "The type of encoding to use when loading the script file.";
    }

    public void setInlineScript(RScript val) {
        this.m_InlineScript = val;
        this.reset();
    }

    public RScript getInlineScript() {
        return this.m_InlineScript;
    }

    public String inlineScriptTipText() {
        return "Inline script to pass into r. The input value can be accessed via 'X'.";
    }

    public void setScriptContainsPlaceholder(boolean value) {
        this.m_ScriptContainsPlaceholder = value;
        this.reset();
    }

    public boolean getScriptContainsPlaceholder() {
        return this.m_ScriptContainsPlaceholder;
    }

    public String scriptContainsPlaceholderTipText() {
        return "Set this to true to enable automatic placeholder expansion in the script.";
    }

    public void setScriptContainsVariable(boolean value) {
        this.m_ScriptContainsVariable = value;
        this.reset();
    }

    public boolean getScriptContainsVariable() {
        return this.m_ScriptContainsVariable;
    }

    public String scriptContainsVariableTipText() {
        return "Set this to true to enable automatic variable expansion in the script.";
    }

    public void setLineByLine(boolean value) {
        this.m_LineByLine = value;
        this.reset();
    }

    public boolean getLineByLine() {
        return this.m_LineByLine;
    }

    public String lineByLineTipText() {
        return "If enabled, the script gets split into lines and evaluated one line at a time (useful for debugging).";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.hasVariable((OptionHandler)this, (String)"scriptFile") || !this.m_ScriptFile.isDirectory() ? QuickInfoHelper.toString((OptionHandler)this, (String)"scriptFile", (Object)this.m_ScriptFile, (String)"file: ") : QuickInfoHelper.toString((OptionHandler)this, (String)"inlineScript", (Object)Shortening.shortenEnd((String)(this.m_InlineScript.isEmpty() ? "-none-" : this.m_InlineScript.stringValue()), (int)50), (String)"script: ");
        ArrayList options = new ArrayList();
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"scriptContainsPlaceholder", (boolean)this.m_ScriptContainsPlaceholder, (String)"PH"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"scriptContainsVariable", (boolean)this.m_ScriptContainsVariable, (String)"Var"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"lineByLine", (!this.m_LineByLine ? 1 : 0) != 0, (String)"Block"));
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Integer.class, String.class, Double.class, Double[].class, Double[][].class, SpreadSheet.class};
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Rserve = (Rserve)ActorUtils.findClosestType((Actor)this, Rserve.class, (boolean)true);
            if (this.m_Rserve == null) {
                result = "Failed to find " + Rserve.class.getName() + " standalone with Rserve configuration!";
            }
        }
        return result;
    }

    protected String doExecute() {
        block28: {
            if (this.m_RConn == null) {
                this.m_RConn = this.m_Rserve.newConnection();
                if (this.m_RConn == null) {
                    return "Could not connect to Rserve!";
                }
            }
            String script = this.m_ScriptFile.isDirectory() || !this.m_ScriptFile.exists() ? this.m_InlineScript.getValue() : Utils.flatten((List)FileUtils.loadFromFile((File)this.m_ScriptFile, (String)this.m_Encoding.getValue()), (String)"\n");
            if (this.m_ScriptContainsVariable) {
                script = this.getVariables().expand(script);
            }
            if (this.m_ScriptContainsPlaceholder) {
                script = Placeholders.getSingleton().expand(script);
            }
            try {
                if (this.m_InputToken.getPayload() instanceof Integer) {
                    this.m_RConn.assign(INPUT, new int[]{(Integer)this.m_InputToken.getPayload()});
                } else if (this.m_InputToken.getPayload() instanceof String) {
                    this.m_RConn.assign(INPUT, (String)this.m_InputToken.getPayload());
                } else if (this.m_InputToken.getPayload() instanceof Double) {
                    this.m_RConn.assign(INPUT, new double[]{(Double)this.m_InputToken.getPayload()});
                } else if (this.m_InputToken.getPayload() instanceof Double[]) {
                    this.m_RConn.assign(INPUT, StatUtils.toDoubleArray((Number[])((Double[])this.m_InputToken.getPayload())));
                } else if (this.m_InputToken.getPayload() instanceof Double[][]) {
                    int i;
                    Double[][] temp = (Double[][])this.m_InputToken.getPayload();
                    double[][] dubMat = new double[temp.length][];
                    for (i = 0; i < temp.length; ++i) {
                        dubMat[i] = StatUtils.toDoubleArray((Number[])temp[i]);
                    }
                    this.m_RConn.assign(INPUT, dubMat[0]);
                    for (i = 1; i < dubMat.length; ++i) {
                        this.m_RConn.assign("tmp", dubMat[i]);
                        this.m_RConn.eval("X<-rbind(X,tmp)");
                    }
                } else if (this.m_InputToken.getPayload() instanceof SpreadSheet) {
                    this.m_RConn.assign(INPUT, RDataHelper.spreadsheetToDataframe((SpreadSheet)this.m_InputToken.getPayload()));
                } else {
                    throw new IllegalStateException("Unhandled class: " + this.m_InputToken.getPayload().getClass());
                }
                if (this.m_LineByLine) {
                    String[] lines;
                    for (String line : lines = script.split("\r?\n")) {
                        if (this.isLoggingEnabled()) {
                            this.getLogger().info("Evaluating: " + line);
                        }
                        try {
                            this.m_RConn.eval(line);
                        }
                        catch (Exception ex) {
                            return this.handleException("Error occurred evaluating: " + line, ex);
                        }
                    }
                    break block28;
                }
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Evaluating:\n" + script);
                }
                try {
                    this.m_RConn.eval(script);
                }
                catch (Exception ex) {
                    return this.handleException("Error occurred evaluating: " + script, ex);
                }
            }
            catch (Exception e) {
                return this.handleException("Error occurred calling Rserve:", e);
            }
        }
        return null;
    }

    public String globalInfo() {
        return "Carries out an r command on the token passed in. The input can be accessed via 'X'.\nVariables are supported as well, e.g.: pow(X,@{exp}) with '@{exp}' being a variable available at execution time.";
    }

    public void wrapUp() {
        if (this.m_Rserve != null) {
            this.m_Rserve.closeConnection(this.m_RConn);
            this.m_RConn = null;
            this.m_Rserve = null;
        }
        super.wrapUp();
    }
}

