/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.io.FileUtils;
import adams.core.option.OptionHandler;
import adams.flow.sink.AbstractFileWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.renjin.serialization.HeadlessWriteContext;
import org.renjin.serialization.RDataWriter;
import org.renjin.serialization.Serialization;
import org.renjin.serialization.WriteContext;
import org.renjin.sexp.SEXP;

public class RenjinFileWriter
extends AbstractFileWriter {
    private static final long serialVersionUID = -8506897965137239463L;
    protected Serialization.SerializationType m_SerializationType;

    public String globalInfo() {
        return "Writes R data to disk.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("serialization-type", "serializationType", (Object)Serialization.SerializationType.BINARY);
    }

    public String outputFileTipText() {
        return "The file to write the R data to.";
    }

    public void setSerializationType(Serialization.SerializationType value) {
        this.m_SerializationType = value;
        this.reset();
    }

    public Serialization.SerializationType getSerializationType() {
        return this.m_SerializationType;
    }

    public String serializationTypeTipText() {
        return "The format of the output file.";
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"serializationType", (Object)this.m_SerializationType, (String)", type: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{SEXP.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doExecute() {
        String result = null;
        SEXP input = null;
        if (this.m_InputToken.hasPayload(SEXP.class)) {
            input = (SEXP)this.m_InputToken.getPayload(SEXP.class);
        } else {
            result = this.m_InputToken.unhandledData();
        }
        if (result == null) {
            FileOutputStream fos = null;
            GZIPOutputStream gos = null;
            try {
                fos = new FileOutputStream(this.m_OutputFile.getAbsolutePath());
                gos = new GZIPOutputStream(fos);
                RDataWriter writer = new RDataWriter((WriteContext)HeadlessWriteContext.INSTANCE, (OutputStream)gos);
                writer.save(input);
                writer.close();
            }
            catch (Exception e) {
                try {
                    result = this.handleException("Failed to write data to: " + this.m_OutputFile, e);
                }
                catch (Throwable throwable) {
                    FileUtils.closeQuietly(gos);
                    FileUtils.closeQuietly(fos);
                    throw throwable;
                }
                FileUtils.closeQuietly((OutputStream)gos);
                FileUtils.closeQuietly((OutputStream)fos);
            }
            FileUtils.closeQuietly((OutputStream)gos);
            FileUtils.closeQuietly((OutputStream)fos);
        }
        return result;
    }
}

