/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.Placeholders;
import adams.core.QuickInfoHelper;
import adams.core.RDataHelper;
import adams.core.RDataType;
import adams.core.Shortening;
import adams.core.Utils;
import adams.core.base.BaseCharset;
import adams.core.io.EncodingSupporter;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.core.scripting.RScript;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.statistics.StatUtils;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;
import adams.flow.standalone.Rserve;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.Rserve.RConnection;

public class RSource
extends AbstractSource
implements EncodingSupporter {
    private static final long serialVersionUID = -3064162887434390818L;
    protected PlaceholderFile m_ScriptFile;
    protected BaseCharset m_Encoding;
    protected RScript m_InlineScript;
    protected RDataType m_returnType;
    protected String m_DataFrameColumns;
    protected boolean m_ScriptContainsPlaceholder;
    protected boolean m_ScriptContainsVariable;
    protected boolean m_LineByLine;
    protected Object m_returnedObject;
    protected RConnection m_RConn;
    protected Rserve m_Rserve;

    public String globalInfo() {
        return "Carries out an R function on the input script and returns data of a particular type.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("script-file", "scriptFile", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("encoding", "encoding", (Object)new BaseCharset());
        this.m_OptionManager.add("script", "inlineScript", (Object)new RScript());
        this.m_OptionManager.add("placeholder", "scriptContainsPlaceholder", (Object)false);
        this.m_OptionManager.add("variable", "scriptContainsVariable", (Object)false);
        this.m_OptionManager.add("line-by-line", "lineByLine", (Object)true);
        this.m_OptionManager.add("return-type", "returnType", (Object)RDataType.Integer);
        this.m_OptionManager.add("data-frame-columns", "dataFrameColumns", (Object)"");
    }

    public void setScriptFile(PlaceholderFile value) {
        this.m_ScriptFile = value;
        this.reset();
    }

    public PlaceholderFile getScriptFile() {
        return this.m_ScriptFile;
    }

    public String scriptFileTipText() {
        return "The script file to load and execute.";
    }

    public void setEncoding(BaseCharset value) {
        this.m_Encoding = value;
        this.reset();
    }

    public BaseCharset getEncoding() {
        return this.m_Encoding;
    }

    public String encodingTipText() {
        return "The type of encoding to use when loading the script file.";
    }

    public void setInlineScript(RScript val) {
        this.m_InlineScript = val;
        this.reset();
    }

    public RScript getInlineScript() {
        return this.m_InlineScript;
    }

    public String inlineScriptTipText() {
        return "Script to pass into r";
    }

    public void setScriptContainsPlaceholder(boolean value) {
        this.m_ScriptContainsPlaceholder = value;
        this.reset();
    }

    public boolean getScriptContainsPlaceholder() {
        return this.m_ScriptContainsPlaceholder;
    }

    public String scriptContainsPlaceholderTipText() {
        return "Set this to true to enable automatic placeholder expansion in the script.";
    }

    public void setScriptContainsVariable(boolean value) {
        this.m_ScriptContainsVariable = value;
        this.reset();
    }

    public boolean getScriptContainsVariable() {
        return this.m_ScriptContainsVariable;
    }

    public String scriptContainsVariableTipText() {
        return "Set this to true to enable automatic variable expansion in the script.";
    }

    public void setLineByLine(boolean value) {
        this.m_LineByLine = value;
        this.reset();
    }

    public boolean getLineByLine() {
        return this.m_LineByLine;
    }

    public String lineByLineTipText() {
        return "If enabled, the script gets split into lines and evaluated one line at a time (useful for debugging).";
    }

    public void setReturnType(RDataType val) {
        this.m_returnType = val;
        this.reset();
    }

    public RDataType getReturnType() {
        return this.m_returnType;
    }

    public String returnTypeTipText() {
        return "Data type of returned object";
    }

    public void setDataFrameColumns(String value) {
        this.m_DataFrameColumns = value;
        this.reset();
    }

    public String getDataFrameColumns() {
        return this.m_DataFrameColumns;
    }

    public String dataFrameColumnsTipText() {
        return "The comma-separated list of dataframe column names to return only (if return type is " + (Object)((Object)RDataType.DataFrame) + ")";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.hasVariable((OptionHandler)this, (String)"scriptFile") || !this.m_ScriptFile.isDirectory() ? QuickInfoHelper.toString((OptionHandler)this, (String)"scriptFile", (Object)this.m_ScriptFile, (String)"file: ") : QuickInfoHelper.toString((OptionHandler)this, (String)"inlineScript", (Object)Shortening.shortenEnd((String)(this.m_InlineScript.isEmpty() ? "-none-" : this.m_InlineScript.stringValue()), (int)50), (String)"script: ");
        ArrayList options = new ArrayList();
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"scriptContainsPlaceholder", (boolean)this.m_ScriptContainsPlaceholder, (String)"PH"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"scriptContainsVariable", (boolean)this.m_ScriptContainsVariable, (String)"Var"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"lineByLine", (!this.m_LineByLine ? 1 : 0) != 0, (String)"Block"));
        result = result + QuickInfoHelper.flatten(options);
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"returnType", (Object)((Object)this.m_returnType), (String)", return: ");
        return result;
    }

    public Class[] generates() {
        switch (this.m_returnType) {
            case Integer: {
                return new Class[]{Integer.class};
            }
            case String: {
                return new Class[]{String.class};
            }
            case Double: {
                return new Class[]{Double.class};
            }
            case DoubleArray: {
                return new Class[]{Double[].class};
            }
            case DoubleMatrix: {
                return new Class[]{Double[][].class};
            }
            case DataFrame: {
                return new Class[]{SpreadSheet.class};
            }
        }
        throw new IllegalStateException("Unhandled data type: " + (Object)((Object)this.m_returnType));
    }

    public Token output() {
        Token result = new Token(this.m_returnedObject);
        this.m_returnedObject = null;
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_returnedObject != null;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Rserve = (Rserve)ActorUtils.findClosestType((Actor)this, Rserve.class, (boolean)true);
            if (this.m_Rserve == null) {
                result = "Failed to find " + Rserve.class.getName() + " standalone with Rserve configuration!";
            }
        }
        return result;
    }

    protected String doExecute() {
        if (this.m_RConn == null) {
            this.m_RConn = this.m_Rserve.newConnection();
            if (this.m_RConn == null) {
                return "Could not connect to Rserve!";
            }
        }
        String script = this.m_ScriptFile.isDirectory() || !this.m_ScriptFile.exists() ? this.m_InlineScript.getValue() : Utils.flatten((List)FileUtils.loadFromFile((File)this.m_ScriptFile, (String)this.m_Encoding.getValue()), (String)"\n");
        if (this.m_ScriptContainsVariable) {
            script = this.getVariables().expand(script);
        }
        if (this.m_ScriptContainsPlaceholder) {
            script = Placeholders.getSingleton().expand(script);
        }
        try {
            REXP rexp = new REXP();
            if (this.m_LineByLine) {
                String[] lines;
                for (String line : lines = script.split("\r?\n")) {
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Evaluating: " + line);
                    }
                    try {
                        rexp = this.m_RConn.eval(line);
                    }
                    catch (Exception ex) {
                        return this.handleException("Error occurred evaluating: " + line, ex);
                    }
                }
            } else {
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Evaluating:\n" + script);
                }
                try {
                    rexp = this.m_RConn.eval(script);
                }
                catch (Exception ex) {
                    return this.handleException("Error occurred evaluating: " + script, ex);
                }
            }
            switch (this.m_returnType) {
                case Integer: {
                    this.m_returnedObject = rexp.asInteger();
                    break;
                }
                case String: {
                    this.m_returnedObject = rexp.asString();
                    break;
                }
                case Double: {
                    this.m_returnedObject = rexp.asDouble();
                    break;
                }
                case DoubleArray: {
                    this.m_returnedObject = StatUtils.toNumberArray((double[])rexp.asDoubles());
                    break;
                }
                case DoubleMatrix: {
                    double[][] dubMat = rexp.asDoubleMatrix();
                    Double[][] result = new Double[dubMat.length][];
                    for (int i = 0; i < dubMat.length; ++i) {
                        result[i] = (Double[])StatUtils.toNumberArray((double[])dubMat[i]);
                    }
                    this.m_returnedObject = result;
                    break;
                }
                case DataFrame: {
                    if (this.m_DataFrameColumns.trim().length() > 0) {
                        this.m_returnedObject = RDataHelper.dataframeToSpreadsheet(rexp, this.m_DataFrameColumns.split(","));
                        break;
                    }
                    this.m_returnedObject = RDataHelper.dataframeToSpreadsheet(rexp);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled data type: " + (Object)((Object)this.m_returnType));
                }
            }
        }
        catch (Exception e) {
            return this.handleException("Error occurred calling Rserve:", e);
        }
        return null;
    }

    public void wrapUp() {
        if (this.m_Rserve != null) {
            this.m_Rserve.closeConnection(this.m_RConn);
            this.m_RConn = null;
            this.m_Rserve = null;
        }
        super.wrapUp();
    }
}

