/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.Placeholders;
import adams.core.QuickInfoHelper;
import adams.core.Shortening;
import adams.core.Utils;
import adams.core.base.BaseCharset;
import adams.core.io.EncodingSupporter;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.core.scripting.RScript;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.standalone.AbstractStandalone;
import adams.flow.standalone.Rserve;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.rosuda.REngine.Rserve.RConnection;

public class RStandalone
extends AbstractStandalone
implements EncodingSupporter {
    private static final long serialVersionUID = 7114485978382420994L;
    protected PlaceholderFile m_ScriptFile;
    protected BaseCharset m_Encoding;
    protected RScript m_InlineScript;
    protected boolean m_ScriptContainsPlaceholder;
    protected boolean m_ScriptContainsVariable;
    protected boolean m_LineByLine;
    protected RConnection m_RConn;
    protected Rserve m_Rserve;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("script-file", "scriptFile", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("encoding", "encoding", (Object)new BaseCharset());
        this.m_OptionManager.add("script", "inlineScript", (Object)new RScript());
        this.m_OptionManager.add("placeholder", "scriptContainsPlaceholder", (Object)false);
        this.m_OptionManager.add("variable", "scriptContainsVariable", (Object)false);
        this.m_OptionManager.add("line-by-line", "lineByLine", (Object)true);
    }

    public void setScriptFile(PlaceholderFile value) {
        this.m_ScriptFile = value;
        this.reset();
    }

    public PlaceholderFile getScriptFile() {
        return this.m_ScriptFile;
    }

    public String scriptFileTipText() {
        return "The script file to load and execute.";
    }

    public void setEncoding(BaseCharset value) {
        this.m_Encoding = value;
        this.reset();
    }

    public BaseCharset getEncoding() {
        return this.m_Encoding;
    }

    public String encodingTipText() {
        return "The type of encoding to use when loading the script file.";
    }

    public RScript getInlineScript() {
        return this.m_InlineScript;
    }

    public void setInlineScript(RScript inlineScript) {
        this.m_InlineScript = inlineScript;
        this.reset();
    }

    public String inlineScriptTipText() {
        return "Script to pass into R.";
    }

    public void setScriptContainsPlaceholder(boolean value) {
        this.m_ScriptContainsPlaceholder = value;
        this.reset();
    }

    public boolean getScriptContainsPlaceholder() {
        return this.m_ScriptContainsPlaceholder;
    }

    public String scriptContainsPlaceholderTipText() {
        return "Set this to true to enable automatic placeholder expansion in the script.";
    }

    public void setScriptContainsVariable(boolean value) {
        this.m_ScriptContainsVariable = value;
        this.reset();
    }

    public boolean getScriptContainsVariable() {
        return this.m_ScriptContainsVariable;
    }

    public String scriptContainsVariableTipText() {
        return "Set this to true to enable automatic variable expansion in the script.";
    }

    public void setLineByLine(boolean value) {
        this.m_LineByLine = value;
        this.reset();
    }

    public boolean getLineByLine() {
        return this.m_LineByLine;
    }

    public String lineByLineTipText() {
        return "If enabled, the script gets split into lines and evaluated one line at a time (useful for debugging).";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.hasVariable((OptionHandler)this, (String)"scriptFile") || !this.m_ScriptFile.isDirectory() ? QuickInfoHelper.toString((OptionHandler)this, (String)"scriptFile", (Object)this.m_ScriptFile, (String)"file: ") : QuickInfoHelper.toString((OptionHandler)this, (String)"inlineScript", (Object)Shortening.shortenEnd((String)(this.m_InlineScript.isEmpty() ? "-none-" : this.m_InlineScript.stringValue()), (int)50), (String)"script: ");
        ArrayList options = new ArrayList();
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"scriptContainsPlaceholder", (boolean)this.m_ScriptContainsPlaceholder, (String)"PH"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"scriptContainsVariable", (boolean)this.m_ScriptContainsVariable, (String)"Var"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"lineByLine", (!this.m_LineByLine ? 1 : 0) != 0, (String)"Block"));
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Rserve = (Rserve)ActorUtils.findClosestType((Actor)this, Rserve.class, (boolean)true);
            if (this.m_Rserve == null) {
                result = "Failed to find " + Rserve.class.getName() + " standalone with Rserve configuration!";
            }
        }
        return result;
    }

    protected String doExecute() {
        if (this.m_RConn == null) {
            this.m_RConn = this.m_Rserve.newConnection();
            if (this.m_RConn == null) {
                return "Could not connect to Rserve!";
            }
        }
        String script = this.m_ScriptFile.isDirectory() || !this.m_ScriptFile.exists() ? this.m_InlineScript.getValue() : Utils.flatten((List)FileUtils.loadFromFile((File)this.m_ScriptFile, (String)this.m_Encoding.getValue()), (String)"\n");
        if (this.m_ScriptContainsVariable) {
            script = this.getVariables().expand(script);
        }
        if (this.m_ScriptContainsPlaceholder) {
            script = Placeholders.getSingleton().expand(script);
        }
        if (this.m_LineByLine) {
            String[] lines;
            for (String line : lines = script.split("\r?\n")) {
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Evaluating: " + line);
                }
                try {
                    this.m_RConn.eval(line);
                }
                catch (Exception ex) {
                    return this.handleException("Error occurred evaluating: " + line, ex);
                }
            }
        } else {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Evaluating:\n" + script);
            }
            try {
                this.m_RConn.eval(script);
            }
            catch (Exception ex) {
                return this.handleException("Error occurred evaluating: " + script, ex);
            }
        }
        return null;
    }

    public String globalInfo() {
        return "Carries out an R function on the input script.";
    }

    public void wrapUp() {
        if (this.m_Rserve != null) {
            this.m_Rserve.closeConnection(this.m_RConn);
            this.m_RConn = null;
            this.m_Rserve = null;
        }
        super.wrapUp();
    }
}

