/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Unknown;
import adams.flow.standalone.RenjinContext;
import adams.flow.transformer.AbstractTransformer;

public class RenjinAddContext
extends AbstractTransformer {
    private static final long serialVersionUID = 8580144999460710110L;
    protected String m_VariableName;
    protected transient RenjinContext m_Context;

    public String globalInfo() {
        return "Adds the object passing through to the Renjin context.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("variable-name", "variableName", (Object)"x");
    }

    public void setVariableName(String value) {
        this.m_VariableName = value;
        this.reset();
    }

    public String getVariableName() {
        return this.m_VariableName;
    }

    public String variableNameTipText() {
        return "The variable name to use in the Renjin context.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"variableName", (Object)this.m_VariableName, (String)"var: ");
    }

    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Context = (RenjinContext)ActorUtils.findClosestType((Actor)this, RenjinContext.class);
            if (this.m_Context == null) {
                result = "Failed to locate instance of " + Utils.classToString(RenjinContext.class) + "!";
            }
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        try {
            this.m_Context.getEngine().put(this.m_VariableName, this.m_InputToken.getPayload());
            this.m_OutputToken = this.m_InputToken;
        }
        catch (Exception e) {
            result = this.handleException("Failed to store incoming data in engine context using: " + this.m_VariableName, e);
        }
        return result;
    }
}

