/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.FileUtils;
import adams.core.io.GzipUtils;
import adams.core.io.PlaceholderFile;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.renjin.serialization.RDataReader;
import org.renjin.sexp.SEXP;

public class RenjinFileReader
extends AbstractTransformer {
    private static final long serialVersionUID = 6309034892839103164L;

    public String globalInfo() {
        return "Reads .rdata files.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{SEXP.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doExecute() {
        String result = null;
        PlaceholderFile input = null;
        if (this.m_InputToken.hasPayload(String.class)) {
            input = new PlaceholderFile((String)this.m_InputToken.getPayload(String.class));
        } else if (this.m_InputToken.hasPayload(File.class)) {
            input = new PlaceholderFile((File)this.m_InputToken.getPayload(File.class));
        } else {
            result = this.m_InputToken.unhandledData();
        }
        if (result == null) {
            FileInputStream fis = null;
            GZIPInputStream gis = null;
            try {
                RDataReader reader;
                if (GzipUtils.isGzipCompressed((File)input)) {
                    fis = new FileInputStream(input.getAbsolutePath());
                    gis = new GZIPInputStream(fis);
                    reader = new RDataReader((InputStream)gis);
                } else {
                    fis = new FileInputStream(input.getAbsolutePath());
                    reader = new RDataReader((InputStream)fis);
                }
                SEXP data = reader.readFile();
                this.m_OutputToken = new Token((Object)data);
                reader.close();
            }
            catch (Exception e) {
                try {
                    result = this.handleException("Failed to read: " + input, e);
                }
                catch (Throwable throwable) {
                    FileUtils.closeQuietly(gis);
                    FileUtils.closeQuietly(fis);
                    throw throwable;
                }
                FileUtils.closeQuietly((InputStream)gis);
                FileUtils.closeQuietly((InputStream)fis);
            }
            FileUtils.closeQuietly((InputStream)gis);
            FileUtils.closeQuietly((InputStream)fis);
        }
        return result;
    }
}

