/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.RObjectHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.DataInfoActor;
import adams.flow.transformer.AbstractArrayProvider;
import org.renjin.sexp.SEXP;

public class RenjinObjectInfo
extends AbstractArrayProvider
implements DataInfoActor {
    private static final long serialVersionUID = 8580144999460710110L;
    protected InfoType m_Type;

    public String globalInfo() {
        return "Outputs information on an R object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)InfoType.LENGTH);
    }

    public String outputArrayTipText() {
        return "If enabled, outputs the elements as array rather than one-by-one.";
    }

    public void setType(InfoType value) {
        this.m_Type = value;
        this.reset();
    }

    public InfoType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of information to generate.";
    }

    protected Class getItemClass() {
        switch (this.m_Type) {
            case LENGTH: 
            case NUM_COLUMNS: 
            case NUM_ROWS: 
            case DIMENSIONS: {
                return Integer.class;
            }
            case DIMENSION_NAMES: {
                return String[].class;
            }
        }
        throw new IllegalStateException("Unhandled type: " + (Object)((Object)this.m_Type));
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type));
    }

    public Class[] accepts() {
        return new Class[]{SEXP.class};
    }

    protected String doExecute() {
        String result = null;
        SEXP input = null;
        this.m_Queue.clear();
        if (this.m_InputToken.hasPayload(SEXP.class)) {
            input = (SEXP)this.m_InputToken.getPayload(SEXP.class);
        } else {
            result = this.m_InputToken.unhandledData();
        }
        if (result == null) {
            switch (this.m_Type) {
                case LENGTH: {
                    this.m_Queue.add(input.length());
                    break;
                }
                case NUM_ROWS: {
                    int[] dims = RObjectHelper.getDimensions(input);
                    if (dims.length > 0) {
                        this.m_Queue.add(dims[0]);
                        break;
                    }
                    this.getLogger().warning("No row dimension available!");
                    break;
                }
                case NUM_COLUMNS: {
                    int[] dims = RObjectHelper.getDimensions(input);
                    if (dims.length > 1) {
                        this.m_Queue.add(dims[1]);
                        break;
                    }
                    this.getLogger().warning("No column dimension available!");
                    break;
                }
                case DIMENSIONS: {
                    int[] dims = RObjectHelper.getDimensions(input);
                    if (dims.length > 0) {
                        for (int i = 0; i < dims.length; ++i) {
                            this.m_Queue.add(dims[i]);
                        }
                        break;
                    }
                    this.getLogger().warning("No dimensions available!");
                    break;
                }
                case DIMENSION_NAMES: {
                    int[] dims = RObjectHelper.getDimensions(input);
                    if (dims.length > 0) {
                        for (int i = 0; i < dims.length; ++i) {
                            this.m_Queue.add(RObjectHelper.getDimensionNames(input, i));
                        }
                        break;
                    }
                    this.getLogger().warning("No dimensions available!");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled type: " + (Object)((Object)this.m_Type));
                }
            }
        }
        return result;
    }

    public static enum InfoType {
        LENGTH,
        NUM_ROWS,
        NUM_COLUMNS,
        DIMENSIONS,
        DIMENSION_NAMES;

    }
}

