/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Placeholders;
import adams.core.QuickInfoHelper;
import adams.core.Shortening;
import adams.core.Utils;
import adams.core.base.BaseCharset;
import adams.core.io.EncodingSupporter;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.core.scripting.RScript;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.standalone.RenjinContext;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.renjin.sexp.SEXP;

public class RenjinTransformer
extends AbstractTransformer
implements EncodingSupporter {
    private static final long serialVersionUID = 8580144999460710110L;
    protected String m_VariableName;
    protected PlaceholderFile m_ScriptFile;
    protected BaseCharset m_Encoding;
    protected RScript m_InlineScript;
    protected boolean m_ScriptContainsPlaceholder;
    protected boolean m_ScriptContainsVariable;
    protected transient RenjinContext m_Context;

    public String globalInfo() {
        return "Adds the object passing through to the Renjin context and executes the script.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("variable-name", "variableName", (Object)"x");
        this.m_OptionManager.add("script-file", "scriptFile", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("encoding", "encoding", (Object)new BaseCharset());
        this.m_OptionManager.add("inline-script", "inlineScript", (Object)new RScript());
        this.m_OptionManager.add("placeholder", "scriptContainsPlaceholder", (Object)false);
        this.m_OptionManager.add("variable", "scriptContainsVariable", (Object)false);
    }

    public void setVariableName(String value) {
        this.m_VariableName = value;
        this.reset();
    }

    public String getVariableName() {
        return this.m_VariableName;
    }

    public String variableNameTipText() {
        return "The variable name to use in the Renjin context.";
    }

    public void setScriptFile(PlaceholderFile value) {
        this.m_ScriptFile = value;
        this.reset();
    }

    public PlaceholderFile getScriptFile() {
        return this.m_ScriptFile;
    }

    public String scriptFileTipText() {
        return "The script file to load and execute.";
    }

    public void setEncoding(BaseCharset value) {
        this.m_Encoding = value;
        this.reset();
    }

    public BaseCharset getEncoding() {
        return this.m_Encoding;
    }

    public String encodingTipText() {
        return "The type of encoding to use when loading the script file.";
    }

    public void setInlineScript(RScript value) {
        this.m_InlineScript = value;
        this.reset();
    }

    public RScript getInlineScript() {
        return this.m_InlineScript;
    }

    public String inlineScriptTipText() {
        return "The inline script to execute (when no script file supplied).";
    }

    public void setScriptContainsPlaceholder(boolean value) {
        this.m_ScriptContainsPlaceholder = value;
        this.reset();
    }

    public boolean getScriptContainsPlaceholder() {
        return this.m_ScriptContainsPlaceholder;
    }

    public String scriptContainsPlaceholderTipText() {
        return "Set this to true to enable automatic placeholder expansion in the script.";
    }

    public void setScriptContainsVariable(boolean value) {
        this.m_ScriptContainsVariable = value;
        this.reset();
    }

    public boolean getScriptContainsVariable() {
        return this.m_ScriptContainsVariable;
    }

    public String scriptContainsVariableTipText() {
        return "Set this to true to enable automatic variable expansion in the script.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"variableName", (Object)this.m_VariableName, (String)"var: ");
        result = QuickInfoHelper.hasVariable((OptionHandler)this, (String)"scriptFile") || !this.m_ScriptFile.isDirectory() ? result + QuickInfoHelper.toString((OptionHandler)this, (String)"scriptFile", (Object)this.m_ScriptFile, (String)", file: ") : result + QuickInfoHelper.toString((OptionHandler)this, (String)"inlineScript", (Object)Shortening.shortenEnd((String)(this.m_InlineScript.isEmpty() ? "-none-" : this.m_InlineScript.stringValue()), (int)50), (String)", inline: ");
        ArrayList options = new ArrayList();
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"scriptContainsPlaceholder", (boolean)this.m_ScriptContainsPlaceholder, (String)"PH"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"scriptContainsVariable", (boolean)this.m_ScriptContainsVariable, (String)"Var"));
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    public Class[] generates() {
        return new Class[]{SEXP.class};
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Context = (RenjinContext)ActorUtils.findClosestType((Actor)this, RenjinContext.class);
            if (this.m_Context == null) {
                result = "Failed to locate instance of " + Utils.classToString(RenjinContext.class) + "!";
            }
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        String script = this.m_ScriptFile.isDirectory() || !this.m_ScriptFile.exists() ? this.m_InlineScript.getValue() : Utils.flatten((List)FileUtils.loadFromFile((File)this.m_ScriptFile, (String)this.m_Encoding.getValue()), (String)"\n");
        if (this.m_ScriptContainsVariable) {
            script = this.getVariables().expand(script);
        }
        if (this.m_ScriptContainsPlaceholder) {
            script = Placeholders.getSingleton().expand(script);
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Evaluating:\n" + script);
        }
        try {
            this.m_Context.getEngine().put(this.m_VariableName, this.m_InputToken.getPayload());
            SEXP output = (SEXP)this.m_Context.getEngine().eval(script);
            this.m_OutputToken = new Token((Object)output);
        }
        catch (Exception e) {
            result = this.handleException("Failed to evaluate script:\n" + script, e);
        }
        return result;
    }
}

