/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.RObjectPath;
import adams.core.Utils;
import adams.core.option.parsing.RObjectPathParsing;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseTextField;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RObjectPathEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler {
    protected BaseTextField m_TextValue;

    public String toCustomStringRepresentation(Object obj) {
        return RObjectPathParsing.toString(null, obj);
    }

    public Object fromCustomStringRepresentation(String str) {
        return new RObjectPath(str);
    }

    public String getJavaInitializationString() {
        String result = "new " + RObjectPath.class.getName() + "(\"" + Utils.backQuoteChars((String)this.getValue().toString()) + "\")";
        return result;
    }

    protected String getStringToPaint() {
        return "" + this.getValue();
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        String val = this.getStringToPaint();
        if (val.isEmpty()) {
            val = "[empty]";
        }
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    protected RObjectPath parse(String s) {
        RObjectPath result;
        try {
            result = new RObjectPath(s);
            if (!result.toString().equals(s)) {
                result = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    protected JComponent createCustomEditor() {
        JPanel panelAll = new JPanel(new BorderLayout());
        JPanel panel = new JPanel(new FlowLayout(0));
        panelAll.add((Component)panel, "Center");
        this.m_TextValue = new BaseTextField(20);
        this.m_TextValue.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    RObjectPathEditor.this.acceptInput();
                } else if (e.getKeyCode() == 27) {
                    e.consume();
                    RObjectPathEditor.this.discardInput();
                } else {
                    super.keyPressed(e);
                }
            }
        });
        JLabel label = new JLabel("Path");
        label.setDisplayedMnemonic('P');
        label.setLabelFor((Component)this.m_TextValue);
        panel.add(label);
        panel.add((Component)this.m_TextValue);
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        panelAll.add((Component)panelButtons, "South");
        BaseButton buttonOK = new BaseButton("OK");
        buttonOK.setMnemonic('O');
        buttonOK.addActionListener(e -> this.acceptInput());
        panelButtons.add((Component)buttonOK);
        BaseButton buttonClose = new BaseButton("Cancel");
        buttonClose.setMnemonic('C');
        buttonClose.addActionListener(e -> this.discardInput());
        panelButtons.add((Component)buttonClose);
        return panelAll;
    }

    protected boolean isValid(String s) {
        return this.parse(s) != null;
    }

    protected boolean isUnchanged(String s) {
        return s.equals(this.getValue().toString());
    }

    protected void acceptInput() {
        String s = this.m_TextValue.getText();
        if (this.isValid(s) && !this.isUnchanged(s)) {
            this.setValue(this.parse(s));
        }
        this.closeDialog(1);
    }

    protected void discardInput() {
        this.closeDialog(0);
    }

    protected void initForDisplay() {
        super.initForDisplay();
        if (!this.m_TextValue.getText().equals("" + this.getValue())) {
            this.m_TextValue.setText("" + this.getValue());
        }
        this.m_TextValue.grabFocus();
    }
}

