/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.input;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.net.rabbitmq.RabbitMQHelper;
import adams.core.net.rabbitmq.receive.AbstractConverter;
import adams.core.net.rabbitmq.receive.StringConverter;
import adams.core.option.OptionHandler;
import adams.flow.container.RabbitMQConsumptionContainer;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.standalone.RabbitMQChannelAction;
import adams.flow.standalone.RabbitMQConnection;
import adams.flow.standalone.rats.input.AbstractBufferedRatInput;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DeliverCallback;

public class RabbitMQConsume
extends AbstractBufferedRatInput {
    private static final long serialVersionUID = 7627032152241150448L;
    protected String m_Exchange;
    protected String m_Queue;
    protected AbstractConverter m_Converter;
    protected int m_Limit;
    protected boolean m_OutputContainer;
    protected transient RabbitMQConnection m_Connection;
    protected transient Channel m_Channel;

    public String globalInfo() {
        return "Consumes data it receives and forwards it.\nIt either binds to the specified exchange (if non-empty and ignores the queue name), or it listens to the specified queue.\nWhen using an exchange, this one must be declared via the " + Utils.classToString(RabbitMQChannelAction.class) + " standalone.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("exchange", "exchange", (Object)"");
        this.m_OptionManager.add("queue", "queue", (Object)"");
        this.m_OptionManager.add("converter", "converter", (Object)new StringConverter());
        this.m_OptionManager.add("limit", "limit", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("output-container", "outputContainer", (Object)false);
    }

    public void setExchange(String value) {
        this.m_Exchange = value;
        this.reset();
    }

    public String getExchange() {
        return this.m_Exchange;
    }

    public String exchangeTipText() {
        return "The name of the exchange.";
    }

    public void setQueue(String value) {
        this.m_Queue = value;
        this.reset();
    }

    public String getQueue() {
        return this.m_Queue;
    }

    public String queueTipText() {
        return "The name of the queue.";
    }

    public void setConverter(AbstractConverter value) {
        this.m_Converter = value;
        this.reset();
    }

    public AbstractConverter getConverter() {
        return this.m_Converter;
    }

    public String converterTipText() {
        return "The converter to use.";
    }

    public void setLimit(int value) {
        if (value <= 0) {
            value = -1;
        }
        this.m_Limit = value;
        this.reset();
    }

    public int getLimit() {
        return this.m_Limit;
    }

    public String limitTipText() {
        return "The limit for data objects received; use <= 0 for unlimited size.";
    }

    public void setOutputContainer(boolean value) {
        this.m_OutputContainer = value;
        this.reset();
    }

    public boolean getOutputContainer() {
        return this.m_OutputContainer;
    }

    public String outputContainerTipText() {
        return "If enabled, outputs the data along side any properties in a " + Utils.classToString(RabbitMQConsumptionContainer.class) + ".";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"exchange", (Object)(this.m_Exchange.isEmpty() ? "-empty-" : this.m_Exchange), (String)"exchange: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"queue", (Object)(this.m_Queue.isEmpty() ? "-empty-" : this.m_Queue), (String)", queue: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"converter", (Object)this.m_Converter, (String)", converter: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"limit", (Object)this.m_Limit, (String)", limit: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"outputContainer", (boolean)this.m_OutputContainer, (String)"container", (String)", ");
        return result;
    }

    public Class generates() {
        if (this.m_OutputContainer) {
            return RabbitMQConsumptionContainer.class;
        }
        return this.m_Converter.generates();
    }

    public String initReception() {
        String result = super.initReception();
        if (result == null) {
            this.m_Connection = (RabbitMQConnection)ActorUtils.findClosestType((Actor)this.m_Owner, RabbitMQConnection.class);
            if (this.m_Connection == null) {
                result = "No " + RabbitMQConnection.class.getName() + " actor found!";
            }
        }
        return result;
    }

    protected String doReceive() {
        String result = null;
        this.m_Converter.setFlowContext((Actor)this.getOwner());
        if (this.m_Channel == null) {
            this.m_Channel = this.m_Connection.createChannel();
            if (this.m_Channel == null) {
                result = "Failed to create a channel!";
            }
        }
        String queue = "";
        DeliverCallback deliverCallback = null;
        if (result == null) {
            this.m_Buffer.clear();
            deliverCallback = (consumerTag, delivery) -> {
                byte[] data = delivery.getBody();
                MessageCollection errors = new MessageCollection();
                Object output = this.m_Converter.convert(data, errors);
                if (this.m_OutputContainer) {
                    this.m_Buffer.add(new RabbitMQConsumptionContainer(output, delivery.getProperties()));
                } else {
                    this.m_Buffer.add(output);
                }
            };
            if (this.m_Exchange.isEmpty()) {
                queue = this.m_Queue;
            } else {
                try {
                    queue = this.m_Channel.queueDeclare().getQueue();
                    this.m_Connection.addAutoCreatedQueue(queue);
                    this.m_Channel.queueBind(queue, this.m_Exchange, "");
                }
                catch (Exception e) {
                    result = this.handleException("Failed to bind queue to exchange!", e);
                }
            }
        }
        if (result == null) {
            try {
                this.m_Channel.basicConsume(queue, true, deliverCallback, consumerTag -> {});
            }
            catch (Exception e) {
                result = this.handleException("Failed to consume data!", e);
            }
        }
        return result;
    }

    public void cleanUp() {
        RabbitMQHelper.closeQuietly((Channel)this.m_Channel);
        this.m_Channel = null;
        this.m_Connection = null;
        super.cleanUp();
    }
}

