/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net.rabbitmq;

import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.util.List;

public class RabbitMQHelper {
    public static Channel createChannel(Connection connection, int prefetchCount) {
        return RabbitMQHelper.createChannel(null, connection, prefetchCount);
    }

    public static Channel createChannel(LoggingSupporter logging, Connection connection, int prefetchCount) {
        Channel result;
        block4: {
            result = null;
            if (prefetchCount < 0) {
                prefetchCount = 0;
            }
            try {
                if (connection != null) {
                    result = connection.createChannel();
                    result.basicQos(prefetchCount);
                }
            }
            catch (Exception e) {
                if (logging == null) break block4;
                LoggingHelper.handleException((LoggingSupporter)logging, (String)"Failed to create channel!", (Throwable)e);
            }
        }
        return result;
    }

    public static void closeQuietly(Channel channel) {
        if (channel != null) {
            try {
                channel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Connection connection) {
        RabbitMQHelper.closeQuietly(connection, null);
    }

    public static void closeQuietly(Connection connection, List<String> queues) {
        if (connection != null && connection.isOpen()) {
            Channel channel;
            if (queues != null && queues.size() > 0 && (channel = RabbitMQHelper.createChannel(null, connection, 0)) != null) {
                for (String queue : queues) {
                    try {
                        channel.queueDelete(queue);
                    }
                    catch (Exception exception) {}
                }
                try {
                    channel.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

