/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net.rabbitmq.channelaction;

import adams.core.QuickInfoHelper;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.net.rabbitmq.channelaction.AbstractChannelActionWithWait;
import adams.core.option.OptionHandler;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;

public class DeclareExchange
extends AbstractChannelActionWithWait {
    private static final long serialVersionUID = 4097038378479166882L;
    protected String m_Exchange;
    protected BuiltinExchangeType m_Type;
    protected boolean m_Durable;
    protected boolean m_AutoDelete;

    public String globalInfo() {
        return "Declares the specified exchange.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("exchange", "exchange", (Object)"");
        this.m_OptionManager.add("type", "type", (Object)BuiltinExchangeType.FANOUT);
        this.m_OptionManager.add("durable", "durable", (Object)false);
        this.m_OptionManager.add("auto-delete", "autoDelete", (Object)false);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"exchange", (Object)(this.m_Exchange.isEmpty() ? "-empty-" : this.m_Exchange), (String)"exchange: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)this.m_Type, (String)", type: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"durable", (boolean)this.m_Durable, (String)"durable", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"autoDelete", (boolean)this.m_AutoDelete, (String)"auto-delete", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"wait", (boolean)this.m_Wait, (String)"wait", (String)", ");
        return result;
    }

    public void setExchange(String value) {
        this.m_Exchange = value;
        this.reset();
    }

    public String getExchange() {
        return this.m_Exchange;
    }

    public String exchangeTipText() {
        return "The name of the exchange.";
    }

    public void setType(BuiltinExchangeType value) {
        this.m_Type = value;
        this.reset();
    }

    public BuiltinExchangeType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of the exchange.";
    }

    public void setDurable(boolean value) {
        this.m_Durable = value;
        this.reset();
    }

    public boolean getDurable() {
        return this.m_Durable;
    }

    public String durableTipText() {
        return "If enabled, declaring a durable exchange (the exchange will survive a server restart).";
    }

    public void setAutoDelete(boolean value) {
        this.m_AutoDelete = value;
        this.reset();
    }

    public boolean getAutoDelete() {
        return this.m_AutoDelete;
    }

    public String autoDeleteTipText() {
        return "If enabled, declaring an autodelete exchange (server will delete it when no longer in use).";
    }

    @Override
    protected String doPerformAction(Channel channel) {
        String result = null;
        try {
            if (this.m_Wait) {
                channel.exchangeDeclare(this.m_Exchange, this.m_Type, this.m_Durable, this.m_AutoDelete, null);
            } else {
                channel.exchangeDeclareNoWait(this.m_Exchange, this.m_Type, this.m_Durable, false, this.m_AutoDelete, null);
            }
        }
        catch (Exception e) {
            result = LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to declare exchange '" + this.m_Exchange + "'!"), (Throwable)e);
        }
        return result;
    }
}

