/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net.rabbitmq.channelaction;

import adams.core.QuickInfoHelper;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.net.rabbitmq.channelaction.AbstractChannelActionWithWait;
import adams.core.option.OptionHandler;
import com.rabbitmq.client.Channel;

public class DeleteQueue
extends AbstractChannelActionWithWait {
    private static final long serialVersionUID = 4097038378479166882L;
    protected String m_Queue;
    protected boolean m_IfUnused;
    protected boolean m_IfEmpty;

    public String globalInfo() {
        return "Deletes the specified queue.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("queue", "queue", (Object)"");
        this.m_OptionManager.add("if-unused", "ifUnused", (Object)false);
        this.m_OptionManager.add("if-empty", "ifEmpty", (Object)false);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"queue", (Object)(this.m_Queue.isEmpty() ? "-empty-" : this.m_Queue), (String)"queue: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"ifUnused", (boolean)this.m_IfUnused, (String)"if unused", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"ifEmpty", (boolean)this.m_IfEmpty, (String)"if empty", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"wait", (boolean)this.m_Wait, (String)"wait", (String)", ");
        return result;
    }

    public void setQueue(String value) {
        this.m_Queue = value;
        this.reset();
    }

    public String getQueue() {
        return this.m_Queue;
    }

    public String queueTipText() {
        return "The name of the queue.";
    }

    public void setIfUnused(boolean value) {
        this.m_IfUnused = value;
        this.reset();
    }

    public boolean getIfUnused() {
        return this.m_IfUnused;
    }

    public String ifUnusedTipText() {
        return "If enabled, only gets deleted if not used.";
    }

    public void setIfEmpty(boolean value) {
        this.m_IfEmpty = value;
        this.reset();
    }

    public boolean getIfEmpty() {
        return this.m_IfEmpty;
    }

    public String ifEmptyTipText() {
        return "If enabled, only gets deleted if empty.";
    }

    @Override
    protected String doPerformAction(Channel channel) {
        String result = null;
        try {
            if (this.m_Wait) {
                channel.queueDelete(this.m_Queue, this.m_IfUnused, this.m_IfEmpty);
            } else {
                channel.queueDeleteNoWait(this.m_Queue, this.m_IfUnused, this.m_IfEmpty);
            }
        }
        catch (Exception e) {
            result = LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to delete queue '" + this.m_Queue + "'!"), (Throwable)e);
        }
        return result;
    }
}

