/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net.rabbitmq.connection;

import adams.core.MessageCollection;
import adams.core.PasswordPrompter;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.BasePassword;
import adams.core.io.ConsoleHelper;
import adams.core.net.rabbitmq.connection.AbstractConnectionFactory;
import adams.core.net.rabbitmq.connection.GuestConnectionFactory;
import adams.core.option.OptionHandler;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.core.StopHelper;
import adams.flow.core.StopMode;
import adams.gui.dialog.PasswordDialog;
import com.rabbitmq.client.ConnectionFactory;
import java.awt.Dialog;
import java.awt.Window;

public class BasicAuthConnectionFactory
extends AbstractConnectionFactory
implements PasswordPrompter {
    private static final long serialVersionUID = 1730696755155054710L;
    protected String m_Host;
    protected int m_Port;
    protected String m_VirtualHost;
    protected String m_User;
    protected BasePassword m_Password;
    protected BasePassword m_ActualPassword;
    protected boolean m_PromptForPassword;
    protected boolean m_StopFlowIfCanceled;
    protected String m_CustomStopMessage;
    protected StopMode m_StopMode;

    public String globalInfo() {
        return "Performs user/password authentication.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("host", "host", (Object)"localhost");
        this.m_OptionManager.add("port", "port", (Object)5672, (Number)1, (Number)65535);
        this.m_OptionManager.add("virtual-host", "virtualHost", (Object)"/");
        this.m_OptionManager.add("user", "user", (Object)"", false);
        this.m_OptionManager.add("password", "password", (Object)new BasePassword(), false);
        this.m_OptionManager.add("prompt-for-password", "promptForPassword", (Object)false);
        this.m_OptionManager.add("stop-if-canceled", "stopFlowIfCanceled", (Object)false);
        this.m_OptionManager.add("custom-stop-message", "customStopMessage", (Object)"");
        this.m_OptionManager.add("stop-mode", "stopMode", (Object)StopMode.GLOBAL);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"user", (Object)(this.m_User.isEmpty() ? "guest" : this.m_User));
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"host", (Object)(this.m_Host.length() == 0 ? "??" : this.m_Host), (String)"@");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"port", (Object)this.m_Port, (String)":");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"virtualHost", (Object)this.m_VirtualHost, (String)"");
        if (QuickInfoHelper.hasVariable((OptionHandler)this, (String)"promptForPassword") || this.m_PromptForPassword) {
            result = result + ", prompt for password";
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"stopFlowIfCanceled", (boolean)this.m_StopFlowIfCanceled, (String)"stop flow", (String)", ");
        }
        return result;
    }

    public void setHost(String value) {
        this.m_Host = value;
        this.reset();
    }

    public String getHost() {
        return this.m_Host;
    }

    public String hostTipText() {
        return "The host (name/IP address) to connect to.";
    }

    public void setPort(int value) {
        if (this.getOptionManager().isValid("port", (Number)value)) {
            this.m_Port = value;
            this.reset();
        }
    }

    public int getPort() {
        return this.m_Port;
    }

    public String portTipText() {
        return "The port to connect to.";
    }

    public void setVirtualHost(String value) {
        this.m_VirtualHost = value;
        this.reset();
    }

    public String getVirtualHost() {
        return this.m_VirtualHost;
    }

    public String virtualHostTipText() {
        return "The virtual host to use on the RabbitMQ server.";
    }

    public void setUser(String value) {
        this.m_User = value;
        this.reset();
    }

    public String getUser() {
        return this.m_User;
    }

    public String userTipText() {
        return "The database user to connect with.";
    }

    public void setPassword(BasePassword value) {
        this.m_Password = value;
        this.reset();
    }

    public BasePassword getPassword() {
        return this.m_Password;
    }

    public String passwordTipText() {
        return "The password of the database user.";
    }

    public void setPromptForPassword(boolean value) {
        this.m_PromptForPassword = value;
        this.reset();
    }

    public boolean getPromptForPassword() {
        return this.m_PromptForPassword;
    }

    public String promptForPasswordTipText() {
        return "If enabled and authentication is required, the user gets prompted for enter a password if none has been provided in the setup.";
    }

    public void setStopFlowIfCanceled(boolean value) {
        this.m_StopFlowIfCanceled = value;
        this.reset();
    }

    public boolean getStopFlowIfCanceled() {
        return this.m_StopFlowIfCanceled;
    }

    public String stopFlowIfCanceledTipText() {
        return "If enabled, the flow gets stopped in case the user cancels the dialog.";
    }

    public void setCustomStopMessage(String value) {
        this.m_CustomStopMessage = value;
        this.reset();
    }

    public String getCustomStopMessage() {
        return this.m_CustomStopMessage;
    }

    public String customStopMessageTipText() {
        return "The custom stop message to use in case a user cancelation stops the flow (default is the full name of the actor)";
    }

    public void setStopMode(StopMode value) {
        this.m_StopMode = value;
        this.reset();
    }

    public StopMode getStopMode() {
        return this.m_StopMode;
    }

    public String stopModeTipText() {
        return "The stop mode to use.";
    }

    public boolean doInteract() {
        boolean result;
        PasswordDialog dlg = new PasswordDialog((Dialog)null, Dialog.ModalityType.DOCUMENT_MODAL);
        dlg.setLocationRelativeTo(this.m_FlowContext.getParentComponent());
        ((Flow)this.m_FlowContext.getRoot()).registerWindow((Window)dlg, dlg.getTitle());
        dlg.setVisible(true);
        ((Flow)this.m_FlowContext.getRoot()).deregisterWindow((Window)dlg);
        boolean bl = result = dlg.getOption() == 0;
        if (result) {
            this.m_ActualPassword = dlg.getPassword();
        }
        return result;
    }

    public boolean supportsHeadlessInteraction() {
        return true;
    }

    public boolean doInteractHeadless() {
        boolean result = false;
        BasePassword password = ConsoleHelper.enterPassword((String)("Please enter password (" + this.m_FlowContext.getName() + "):"));
        if (password != null) {
            result = true;
            this.m_ActualPassword = password;
        }
        return result;
    }

    @Override
    protected boolean requiresFlowContext() {
        return this.m_PromptForPassword;
    }

    @Override
    protected String check() {
        String result = super.check();
        if (result == null && this.m_User.isEmpty()) {
            result = "No user provided! For anonymous/guest connection, use " + Utils.classToString(GuestConnectionFactory.class) + " instead.";
        }
        return result;
    }

    @Override
    protected ConnectionFactory doGenerate(MessageCollection errors) {
        ConnectionFactory result = new ConnectionFactory();
        result.setHost(this.m_Host);
        result.setPort(this.m_Port);
        result.setVirtualHost(this.m_VirtualHost);
        result.setUsername(this.m_User);
        this.m_ActualPassword = this.m_Password;
        String msg = null;
        if (this.m_PromptForPassword && this.m_Password.getValue().length() == 0) {
            if (!this.m_FlowContext.isHeadless()) {
                if (!this.doInteract() && this.m_StopFlowIfCanceled) {
                    if (this.m_CustomStopMessage == null || this.m_CustomStopMessage.trim().length() == 0) {
                        StopHelper.stop((Actor)this.m_FlowContext, (StopMode)this.m_StopMode, (String)("Flow canceled: " + this.m_FlowContext.getFullName()));
                    } else {
                        StopHelper.stop((Actor)this.m_FlowContext, (StopMode)this.m_StopMode, (String)this.m_CustomStopMessage);
                    }
                    msg = this.m_FlowContext.getStopMessage();
                }
            } else if (this.supportsHeadlessInteraction() && !this.doInteractHeadless() && this.m_StopFlowIfCanceled) {
                if (this.m_CustomStopMessage == null || this.m_CustomStopMessage.trim().length() == 0) {
                    StopHelper.stop((Actor)this.m_FlowContext, (StopMode)this.m_StopMode, (String)("Flow canceled: " + this.m_FlowContext.getFullName()));
                } else {
                    StopHelper.stop((Actor)this.m_FlowContext, (StopMode)this.m_StopMode, (String)this.m_CustomStopMessage);
                }
                msg = this.m_FlowContext.getStopMessage();
            }
        }
        if (msg == null) {
            result.setPassword(this.m_ActualPassword.getValue());
        } else {
            errors.add(msg);
        }
        return result;
    }
}

