/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net.rabbitmq.connection;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.net.rabbitmq.connection.AbstractConnectionFactory;
import adams.core.net.rabbitmq.connection.GuestConnectionFactory;
import adams.core.option.OptionHandler;
import com.rabbitmq.client.ConnectionFactory;

public class NonValidatingSSLConnectionFactory
extends AbstractConnectionFactory {
    private static final long serialVersionUID = 7600989409175939L;
    protected AbstractConnectionFactory m_ConnectionFactory;

    public String globalInfo() {
        return "For encrypting a connection with SSL (performs no validation).\nUse only for testing/development!";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("connection-factory", "connectionFactory", (Object)new GuestConnectionFactory());
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"connectionFactory", (Object)((Object)this.m_ConnectionFactory), (String)"connection: ");
    }

    public void setConnectionFactory(AbstractConnectionFactory value) {
        this.m_ConnectionFactory = value;
        this.reset();
    }

    public AbstractConnectionFactory getConnectionFactory() {
        return this.m_ConnectionFactory;
    }

    public String connectionFactoryTipText() {
        return "The base connection factory to encrypt.";
    }

    @Override
    protected boolean requiresFlowContext() {
        return false;
    }

    @Override
    protected ConnectionFactory doGenerate(MessageCollection errors) {
        String msg = null;
        ConnectionFactory result = this.m_ConnectionFactory.generate(errors);
        if (result == null) {
            return null;
        }
        try {
            result.useSslProtocol();
        }
        catch (Exception e) {
            msg = LoggingHelper.handleException((LoggingSupporter)this, (String)"Failed to enable use of SSL!", (Throwable)e);
        }
        if (msg != null) {
            errors.add(msg);
        }
        if (!errors.isEmpty()) {
            return null;
        }
        return result;
    }
}

