/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net.rabbitmq.connection;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.base.BasePassword;
import adams.core.io.ConsoleHelper;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.net.rabbitmq.connection.AbstractConnectionFactory;
import adams.core.net.rabbitmq.connection.GuestConnectionFactory;
import adams.core.option.OptionHandler;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.core.StopHelper;
import adams.flow.core.StopMode;
import adams.gui.dialog.PasswordDialog;
import com.rabbitmq.client.ConnectionFactory;
import java.awt.Dialog;
import java.awt.Window;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class SSLConnectionFactory
extends AbstractConnectionFactory {
    private static final long serialVersionUID = 7600989409175939L;
    protected AbstractConnectionFactory m_ConnectionFactory;
    protected String m_KeyManagerKeystoreType;
    protected PlaceholderFile m_KeyManagerKeystoreFile;
    protected BasePassword m_KeyManagerKeystorePassphrase;
    protected String m_KeyManagerAlgorithm;
    protected transient KeyManagerFactory m_KeyManagerFactory;
    protected String m_TrustManagerKeystoreType;
    protected PlaceholderFile m_TrustManagerKeystoreFile;
    protected BasePassword m_TrustManagerKeystorePassphrase;
    protected String m_TrustManagerAlgorithm;
    protected transient TrustManagerFactory m_TrustManagerFactory;
    protected BasePassword m_ActualPassphrase;
    protected boolean m_PromptForPassword;
    protected boolean m_StopFlowIfCanceled;
    protected String m_CustomStopMessage;
    protected StopMode m_StopMode;
    protected String m_Protocol;
    protected transient SSLContext m_SSLContext;
    protected boolean m_HostnameVerification;

    public String globalInfo() {
        return "For encrypting a connection with SSL.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("connection-factory", "connectionFactory", (Object)new GuestConnectionFactory());
        this.m_OptionManager.add("keymanager-keystore-type", "keyManagerKeystoreType", (Object)"PKCS12");
        this.m_OptionManager.add("keymanager-keystore-file", "keyManagerKeystoreFile", (Object)new PlaceholderFile());
        this.m_OptionManager.add("keymanager-keystore-passphrase", "keyManagerKeystorePassphrase", (Object)new BasePassword(""), false);
        this.m_OptionManager.add("keymanager-algorithm", "keyManagerAlgorithm", (Object)"SunX509");
        this.m_OptionManager.add("trustmanager-keystore-type", "trustManagerKeystoreType", (Object)"JKS");
        this.m_OptionManager.add("trustmanager-keystore-file", "trustManagerKeystoreFile", (Object)new PlaceholderFile());
        this.m_OptionManager.add("trustmanager-keystore-passphrase", "trustManagerKeystorePassphrase", (Object)new BasePassword(""), false);
        this.m_OptionManager.add("trustmanager-algorithm", "trustManagerAlgorithm", (Object)"SunX509");
        this.m_OptionManager.add("prompt-for-password", "promptForPassword", (Object)false);
        this.m_OptionManager.add("stop-if-canceled", "stopFlowIfCanceled", (Object)false);
        this.m_OptionManager.add("custom-stop-message", "customStopMessage", (Object)"");
        this.m_OptionManager.add("stop-mode", "stopMode", (Object)StopMode.GLOBAL);
        this.m_OptionManager.add("protocol", "protocol", (Object)"TLSv1.2");
        this.m_OptionManager.add("hostname-verification", "hostnameVerification", (Object)false);
    }

    protected void reset() {
        super.reset();
        this.m_KeyManagerFactory = null;
        this.m_TrustManagerFactory = null;
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"connectionFactory", (Object)((Object)this.m_ConnectionFactory), (String)"connection: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"keyManagerKeystoreType", (Object)this.m_KeyManagerKeystoreType, (String)", KM type: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"keyManagerKeystoreFile", (Object)this.m_KeyManagerKeystoreFile, (String)", KM file: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"keyManagerAlgorithm", (Object)this.m_KeyManagerAlgorithm, (String)", KM algorithm: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"trustManagerKeystoreType", (Object)this.m_TrustManagerKeystoreType, (String)", TM type: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"trustManagerKeystoreFile", (Object)this.m_TrustManagerKeystoreFile, (String)", TM file: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"trustManagerAlgorithm", (Object)this.m_TrustManagerAlgorithm, (String)", TM algorithm: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"protocol", (Object)this.m_Protocol, (String)", protocol: ");
        ArrayList options = new ArrayList();
        if (QuickInfoHelper.hasVariable((OptionHandler)this, (String)"promptForPassword") || this.m_PromptForPassword) {
            QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"promptForPassword", (boolean)this.m_PromptForPassword, (String)"prompt for password"));
            QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"stopFlowIfCanceled", (boolean)this.m_StopFlowIfCanceled, (String)"stop flow"));
            QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"hostnameVerification", (boolean)this.m_HostnameVerification, (String)"hostname verification"));
        }
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    public void setConnectionFactory(AbstractConnectionFactory value) {
        this.m_ConnectionFactory = value;
        this.reset();
    }

    public AbstractConnectionFactory getConnectionFactory() {
        return this.m_ConnectionFactory;
    }

    public String connectionFactoryTipText() {
        return "The base connection factory to encrypt.";
    }

    public void setKeyManagerKeystoreType(String value) {
        this.m_KeyManagerKeystoreType = value;
        this.reset();
    }

    public String getKeyManagerKeystoreType() {
        return this.m_KeyManagerKeystoreType;
    }

    public String keyManagerKeystoreTypeTipText() {
        return "The type of the keystore, eg PKCS12 or JKS (KeyManager).";
    }

    public void setKeyManagerKeystoreFile(PlaceholderFile value) {
        this.m_KeyManagerKeystoreFile = value;
        this.reset();
    }

    public PlaceholderFile getKeyManagerKeystoreFile() {
        return this.m_KeyManagerKeystoreFile;
    }

    public String keyManagerKeystoreFileTipText() {
        return "The location of the keystore (KeyManager).";
    }

    public void setKeyManagerKeystorePassphrase(BasePassword value) {
        this.m_KeyManagerKeystorePassphrase = value;
        this.reset();
    }

    public BasePassword getKeyManagerKeystorePassphrase() {
        return this.m_KeyManagerKeystorePassphrase;
    }

    public String keyManagerKeystorePassphraseTipText() {
        return "The passphrase for the keystore file, ignored if empty (KeyManager).";
    }

    public void setKeyManagerAlgorithm(String value) {
        this.m_KeyManagerAlgorithm = value;
        this.reset();
    }

    public String getKeyManagerAlgorithm() {
        return this.m_KeyManagerAlgorithm;
    }

    public String keyManagerAlgorithmTipText() {
        return "The algorithm to use (KeyManager).";
    }

    public void setTrustManagerKeystoreType(String value) {
        this.m_TrustManagerKeystoreType = value;
        this.reset();
    }

    public String getTrustManagerKeystoreType() {
        return this.m_TrustManagerKeystoreType;
    }

    public String trustManagerKeystoreTypeTipText() {
        return "The type of the keystore, eg PKCS12 or JKS (TrustManager).";
    }

    public void setTrustManagerKeystoreFile(PlaceholderFile value) {
        this.m_TrustManagerKeystoreFile = value;
        this.reset();
    }

    public PlaceholderFile getTrustManagerKeystoreFile() {
        return this.m_TrustManagerKeystoreFile;
    }

    public String trustManagerKeystoreFileTipText() {
        return "The location of the keystore (TrustManager).";
    }

    public void setTrustManagerKeystorePassphrase(BasePassword value) {
        this.m_TrustManagerKeystorePassphrase = value;
        this.reset();
    }

    public BasePassword getTrustManagerKeystorePassphrase() {
        return this.m_TrustManagerKeystorePassphrase;
    }

    public String trustManagerKeystorePassphraseTipText() {
        return "The passphrase for the keystore file, ignored if empty (TrustManager).";
    }

    public void setTrustManagerAlgorithm(String value) {
        this.m_TrustManagerAlgorithm = value;
        this.reset();
    }

    public String getTrustManagerAlgorithm() {
        return this.m_TrustManagerAlgorithm;
    }

    public String trustManagerAlgorithmTipText() {
        return "The algorithm to use (TrustManager).";
    }

    public void setPromptForPassword(boolean value) {
        this.m_PromptForPassword = value;
        this.reset();
    }

    public boolean getPromptForPassword() {
        return this.m_PromptForPassword;
    }

    public String promptForPasswordTipText() {
        return "If enabled, the user gets prompted for enter a password if none has been provided in the setup.";
    }

    public void setStopFlowIfCanceled(boolean value) {
        this.m_StopFlowIfCanceled = value;
        this.reset();
    }

    public boolean getStopFlowIfCanceled() {
        return this.m_StopFlowIfCanceled;
    }

    public String stopFlowIfCanceledTipText() {
        return "If enabled, the flow gets stopped in case the user cancels the dialog.";
    }

    public void setCustomStopMessage(String value) {
        this.m_CustomStopMessage = value;
        this.reset();
    }

    public String getCustomStopMessage() {
        return this.m_CustomStopMessage;
    }

    public String customStopMessageTipText() {
        return "The custom stop message to use in case a user cancelation stops the flow (default is the full name of the actor)";
    }

    public void setStopMode(StopMode value) {
        this.m_StopMode = value;
        this.reset();
    }

    public StopMode getStopMode() {
        return this.m_StopMode;
    }

    public String stopModeTipText() {
        return "The stop mode to use.";
    }

    public void setProtocol(String value) {
        this.m_Protocol = value;
        this.reset();
    }

    public String getProtocol() {
        return this.m_Protocol;
    }

    public String protocolTipText() {
        return "The protocol to use, eg TLSv1, TLSv1.1 or TLSv1.2.";
    }

    public void setHostnameVerification(boolean value) {
        this.m_HostnameVerification = value;
        this.reset();
    }

    public boolean getHostnameVerification() {
        return this.m_HostnameVerification;
    }

    public String hostnameVerificationTipText() {
        return "If enabled, hostnames get verified.";
    }

    @Override
    protected boolean requiresFlowContext() {
        return this.m_PromptForPassword || this.m_ConnectionFactory.requiresFlowContext();
    }

    public boolean doInteract() {
        boolean result;
        PasswordDialog dlg = new PasswordDialog((Dialog)null, Dialog.ModalityType.DOCUMENT_MODAL);
        dlg.setLabelPassword("Keystore passphrase");
        dlg.setLocationRelativeTo(this.m_FlowContext.getParentComponent());
        ((Flow)this.m_FlowContext.getRoot()).registerWindow((Window)dlg, dlg.getTitle());
        dlg.setVisible(true);
        ((Flow)this.m_FlowContext.getRoot()).deregisterWindow((Window)dlg);
        boolean bl = result = dlg.getOption() == 0;
        if (result) {
            this.m_ActualPassphrase = dlg.getPassword();
        }
        return result;
    }

    public boolean supportsHeadlessInteraction() {
        return true;
    }

    public boolean doInteractHeadless() {
        boolean result = false;
        BasePassword password = ConsoleHelper.enterPassword((String)("Please enter keystore passphrase (" + this.m_FlowContext.getName() + "):"));
        if (password != null) {
            result = true;
            this.m_ActualPassphrase = password;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ConnectionFactory doGenerate(MessageCollection errors) {
        KeyStore keystore;
        FileInputStream fis;
        String msg = null;
        ConnectionFactory result = this.m_ConnectionFactory.generate(errors);
        if (result == null) {
            return null;
        }
        if (this.m_KeyManagerFactory == null) {
            this.m_ActualPassphrase = this.m_KeyManagerKeystorePassphrase;
            if (this.m_PromptForPassword && this.m_KeyManagerKeystorePassphrase.getValue().length() == 0) {
                if (!this.getFlowContext().isHeadless()) {
                    if (!this.doInteract() && this.m_StopFlowIfCanceled) {
                        if (this.m_CustomStopMessage == null || this.m_CustomStopMessage.trim().length() == 0) {
                            StopHelper.stop((Actor)this.getFlowContext(), (StopMode)this.m_StopMode, (String)("Flow canceled: " + this.getFlowContext().getFullName()));
                        } else {
                            StopHelper.stop((Actor)this.getFlowContext(), (StopMode)this.m_StopMode, (String)this.m_CustomStopMessage);
                        }
                        msg = this.getFlowContext().getStopMessage();
                    }
                } else if (this.supportsHeadlessInteraction() && !this.doInteractHeadless() && this.m_StopFlowIfCanceled) {
                    if (this.m_CustomStopMessage == null || this.m_CustomStopMessage.trim().length() == 0) {
                        StopHelper.stop((Actor)this.getFlowContext(), (StopMode)this.m_StopMode, (String)("Flow canceled: " + this.getFlowContext().getFullName()));
                    } else {
                        StopHelper.stop((Actor)this.getFlowContext(), (StopMode)this.m_StopMode, (String)this.m_CustomStopMessage);
                    }
                    msg = this.getFlowContext().getStopMessage();
                }
            }
            if (msg == null) {
                fis = null;
                try {
                    keystore = KeyStore.getInstance(this.m_KeyManagerKeystoreType);
                    fis = new FileInputStream(this.m_KeyManagerKeystoreFile.getAbsolutePath());
                    keystore.load(fis, this.m_ActualPassphrase.getValue().toCharArray());
                    this.m_KeyManagerFactory = KeyManagerFactory.getInstance(this.m_KeyManagerAlgorithm);
                    this.m_KeyManagerFactory.init(keystore, this.m_ActualPassphrase.getValue().toCharArray());
                    FileUtils.closeQuietly((InputStream)fis);
                }
                catch (Exception e) {
                    msg = LoggingHelper.handleException((LoggingSupporter)this, (String)"Failed to initialize the KeyManagerFactory!", (Throwable)e);
                }
                finally {
                    FileUtils.closeQuietly(fis);
                }
            }
            if (msg != null) {
                errors.add(msg);
            }
            if (!errors.isEmpty()) {
                return null;
            }
        }
        if (this.m_TrustManagerFactory == null) {
            this.m_ActualPassphrase = this.m_TrustManagerKeystorePassphrase;
            if (this.m_PromptForPassword && this.m_TrustManagerKeystorePassphrase.getValue().length() == 0) {
                if (!this.getFlowContext().isHeadless()) {
                    if (!this.doInteract() && this.m_StopFlowIfCanceled) {
                        if (this.m_CustomStopMessage == null || this.m_CustomStopMessage.trim().length() == 0) {
                            StopHelper.stop((Actor)this.getFlowContext(), (StopMode)this.m_StopMode, (String)("Flow canceled: " + this.getFlowContext().getFullName()));
                        } else {
                            StopHelper.stop((Actor)this.getFlowContext(), (StopMode)this.m_StopMode, (String)this.m_CustomStopMessage);
                        }
                        msg = this.getFlowContext().getStopMessage();
                    }
                } else if (this.supportsHeadlessInteraction() && !this.doInteractHeadless() && this.m_StopFlowIfCanceled) {
                    if (this.m_CustomStopMessage == null || this.m_CustomStopMessage.trim().length() == 0) {
                        StopHelper.stop((Actor)this.getFlowContext(), (StopMode)this.m_StopMode, (String)("Flow canceled: " + this.getFlowContext().getFullName()));
                    } else {
                        StopHelper.stop((Actor)this.getFlowContext(), (StopMode)this.m_StopMode, (String)this.m_CustomStopMessage);
                    }
                    msg = this.getFlowContext().getStopMessage();
                }
            }
            if (msg == null) {
                fis = null;
                try {
                    keystore = KeyStore.getInstance(this.m_TrustManagerKeystoreType);
                    fis = new FileInputStream(this.m_TrustManagerKeystoreFile.getAbsolutePath());
                    keystore.load(fis, this.m_ActualPassphrase.getValue().toCharArray());
                    this.m_TrustManagerFactory = TrustManagerFactory.getInstance(this.m_TrustManagerAlgorithm);
                    this.m_TrustManagerFactory.init(keystore);
                }
                catch (Exception e) {
                    try {
                        msg = LoggingHelper.handleException((LoggingSupporter)this, (String)"Failed to initialize the TrustManagerFactory!", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        FileUtils.closeQuietly(fis);
                        throw throwable;
                    }
                    FileUtils.closeQuietly((InputStream)fis);
                }
                FileUtils.closeQuietly((InputStream)fis);
            }
        }
        if (msg != null) {
            errors.add(msg);
        }
        if (!errors.isEmpty()) {
            return null;
        }
        this.m_SSLContext = null;
        try {
            this.m_SSLContext = SSLContext.getInstance(this.m_Protocol);
            this.m_SSLContext.init(this.m_KeyManagerFactory.getKeyManagers(), this.m_TrustManagerFactory.getTrustManagers(), null);
            result.useSslProtocol(this.m_SSLContext);
            if (this.m_HostnameVerification) {
                result.enableHostnameVerification();
            }
        }
        catch (Exception e) {
            msg = LoggingHelper.handleException((LoggingSupporter)this, (String)"Failed to instantiate SSL context!", (Throwable)e);
        }
        if (msg != null) {
            errors.add(msg);
        }
        if (!errors.isEmpty()) {
            return null;
        }
        return result;
    }
}

