/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net.rabbitmq.deliveryaction;

import adams.core.QuickInfoHelper;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.net.rabbitmq.deliveryaction.AbstractDeliveryAction;
import adams.core.option.OptionHandler;
import com.rabbitmq.client.Channel;

public class Ack
extends AbstractDeliveryAction {
    private static final long serialVersionUID = 4328085615118918815L;
    protected boolean m_Multiple;

    public String globalInfo() {
        return "Acknowledges the successful processing of the message with the specified delivery tag.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("multiple", "multiple", (Object)false);
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"multiple", (boolean)this.m_Multiple, (String)"multiple");
    }

    public void setMultiple(boolean value) {
        this.m_Multiple = value;
        this.reset();
    }

    public boolean getMultiple() {
        return this.m_Multiple;
    }

    public String multipleTipText() {
        return "If enabled, acknowledges all messages up to and including the delivery tag.";
    }

    @Override
    protected String doPerformAction(Channel channel, long tag) {
        try {
            channel.basicAck(tag, this.m_Multiple);
            return null;
        }
        catch (Exception e) {
            return LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to ack tag " + tag + " (multiple=" + this.m_Multiple + ")!"), (Throwable)e);
        }
    }
}

