/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net.rabbitmq.receive;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.SerializationHelper;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderDirectory;
import adams.core.net.rabbitmq.receive.AbstractConverter;
import adams.core.net.rabbitmq.receive.BinaryConverter;
import adams.core.net.rabbitmq.receive.StringConverter;
import adams.core.option.OptionHandler;
import java.io.File;

public class FileBasedConverter
extends AbstractConverter {
    private static final long serialVersionUID = -736244897402323379L;
    protected AbstractConverter m_Converter;
    protected PlaceholderDirectory m_PayloadDir;

    public String globalInfo() {
        return "Instead of sending potentially large payloads via a RabbitMQ, this meta-converter loads the actual payload from the specified directory using the file name (without path) received via RabbitMQ.\nOf course, requires sending and receiving ends to have access to the same directory.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("converter", "converter", (Object)new BinaryConverter());
        this.m_OptionManager.add("payload-dir", "payloadDir", (Object)new PlaceholderDirectory());
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"converter", (Object)((Object)this.m_Converter), (String)"converter: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"payloadDir", (Object)this.m_PayloadDir, (String)", dir: ");
        return result;
    }

    public void setConverter(AbstractConverter value) {
        this.m_Converter = value;
        this.reset();
    }

    public AbstractConverter getConverter() {
        return this.m_Converter;
    }

    public String converterTipText() {
        return "The base converter for performing the actual conversion.";
    }

    public void setPayloadDir(PlaceholderDirectory value) {
        this.m_PayloadDir = value;
        this.reset();
    }

    public PlaceholderDirectory getPayloadDir() {
        return this.m_PayloadDir;
    }

    public String payloadDirTipText() {
        return "The directory for saving the actual payload to.";
    }

    @Override
    public Class generates() {
        return this.m_Converter.generates();
    }

    @Override
    protected Object doConvert(byte[] payload, MessageCollection errors) {
        Object result;
        Object filename = new StringConverter().convert(payload, errors);
        if (!errors.isEmpty()) {
            return null;
        }
        File file = new File(this.m_PayloadDir.getAbsolutePath() + File.separator + filename);
        try {
            byte[] data = (byte[])SerializationHelper.read((String)file.getAbsolutePath());
            result = this.m_Converter.convert(data, errors);
            if (!FileUtils.delete((File)file)) {
                this.getLogger().warning("Failed to delete payload file: " + file);
            }
        }
        catch (Exception e) {
            errors.add("Failed to deserialize payload from: " + file, (Throwable)e);
            result = null;
        }
        return result;
    }
}

