/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net.rabbitmq.receive;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.base.BaseCharset;
import adams.core.io.EncodingSupporter;
import adams.core.net.rabbitmq.receive.AbstractConverter;
import adams.core.option.OptionHandler;

public class StringConverter
extends AbstractConverter
implements EncodingSupporter {
    private static final long serialVersionUID = 1775246651405193885L;
    protected BaseCharset m_Encoding;

    public String globalInfo() {
        return "For converting data back into strings.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("encoding", "encoding", (Object)new BaseCharset());
    }

    public void setEncoding(BaseCharset value) {
        this.m_Encoding = value;
        this.reset();
    }

    public BaseCharset getEncoding() {
        return this.m_Encoding;
    }

    public String encodingTipText() {
        return "The type of encoding to use when reading the file, use empty string for default.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"encoding", (Object)this.m_Encoding, (String)"encoding: ");
    }

    @Override
    public Class generates() {
        return String.class;
    }

    @Override
    protected Object doConvert(byte[] payload, MessageCollection errors) {
        return new String(payload, this.m_Encoding.charsetValue());
    }
}

